/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.vehiclerouting.domain;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.optaweb.vehiclerouting.domain.Coordinates;
import org.optaweb.vehiclerouting.domain.Location;
import org.optaweb.vehiclerouting.domain.Route;
import org.optaweb.vehiclerouting.domain.RouteWithTrack;

class RouteWithTrackTest {
    private final Location depot = new Location(1L, Coordinates.valueOf((double)5.0, (double)5.0));
    private final Location visit1 = new Location(2L, Coordinates.valueOf((double)5.0, (double)5.0));
    private final Location visit2 = new Location(3L, Coordinates.valueOf((double)5.0, (double)5.0));

    RouteWithTrackTest() {
    }

    @Test
    void constructor_args_not_null() {
        Route route = new Route(this.depot, Collections.emptyList());
        Assertions.assertThatNullPointerException().isThrownBy(() -> new RouteWithTrack(route, null));
        Assertions.assertThatNullPointerException().isThrownBy(() -> new Route(null, Collections.emptyList()));
    }

    @Test
    void cannot_modify_track_externally() {
        Route route = new Route(this.depot, Arrays.asList(this.visit1, this.visit2));
        ArrayList<List<Coordinates>> track = new ArrayList<List<Coordinates>>();
        track.add(Arrays.asList(Coordinates.valueOf((double)1.0, (double)2.0)));
        RouteWithTrack routeWithTrack = new RouteWithTrack(route, track);
        Assertions.assertThatExceptionOfType(UnsupportedOperationException.class).isThrownBy(() -> routeWithTrack.track().clear());
    }

    @Test
    void when_route_is_empty_track_must_be_empty() {
        Route emptyRoute = new Route(this.depot, Collections.emptyList());
        ArrayList<List<Coordinates>> track = new ArrayList<List<Coordinates>>();
        track.add(Arrays.asList(Coordinates.valueOf((double)1.0, (double)2.0)));
        Assertions.assertThatIllegalArgumentException().isThrownBy(() -> new RouteWithTrack(emptyRoute, (List)track));
    }

    @Test
    void when_route_is_nonempty_track_must_be_nonempty() {
        Route route = new Route(this.depot, Arrays.asList(this.visit1, this.visit2));
        ArrayList emptyTrack = new ArrayList();
        Assertions.assertThatIllegalArgumentException().isThrownBy(() -> new RouteWithTrack(route, (List)emptyTrack));
    }
}

