/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.vehiclerouting.domain;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.optaweb.vehiclerouting.domain.Coordinates;
import org.optaweb.vehiclerouting.domain.Location;
import org.optaweb.vehiclerouting.domain.Route;
import org.optaweb.vehiclerouting.domain.RouteWithTrack;
import org.optaweb.vehiclerouting.domain.RoutingPlan;

class RoutingPlanTest {
    private final Location depot = new Location(1L, Coordinates.valueOf((double)5.0, (double)5.0));
    private final RouteWithTrack emptyRoute = new RouteWithTrack(new Route(this.depot, Collections.emptyList()), Collections.emptyList());

    RoutingPlanTest() {
    }

    @Test
    void constructor_args_not_null() {
        Assertions.assertThatNullPointerException().isThrownBy(() -> new RoutingPlan(null, this.depot, Collections.emptyList()));
        Assertions.assertThatNullPointerException().isThrownBy(() -> new RoutingPlan("", this.depot, null));
    }

    @Test
    void no_routes_without_a_depot() {
        Assertions.assertThatIllegalArgumentException().isThrownBy(() -> new RoutingPlan("", null, Arrays.asList(this.emptyRoute)));
    }

    @Test
    void cannot_modify_routes_externally() {
        ArrayList<RouteWithTrack> routes = new ArrayList<RouteWithTrack>();
        routes.add(this.emptyRoute);
        RoutingPlan routingPlan = new RoutingPlan("", this.depot, routes);
        Assertions.assertThatExceptionOfType(UnsupportedOperationException.class).isThrownBy(() -> routingPlan.routes().clear());
    }
}

