/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.vehiclerouting.plugin.planner;

import java.util.HashMap;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.optaplanner.examples.vehiclerouting.domain.location.RoadLocation;
import org.optaweb.vehiclerouting.domain.Coordinates;
import org.optaweb.vehiclerouting.domain.Location;
import org.optaweb.vehiclerouting.plugin.planner.DistanceMap;

class DistanceMapTest {
    DistanceMapTest() {
    }

    @Test
    void distance_map_should_convert_millis_to_secs() {
        Location location = new Location(1L, Coordinates.valueOf((double)8.0, (double)0.8));
        long otherId = 2L;
        RoadLocation roadLocation = new RoadLocation(otherId, 0.0, 0.0);
        double distance = 45000.0;
        HashMap<Long, Double> distanceMap = new HashMap<Long, Double>(1);
        distanceMap.put(otherId, distance);
        DistanceMap distanceMapBridge = new DistanceMap(location, distanceMap);
        Assertions.assertThat((Map)distanceMapBridge).containsKey((Object)roadLocation);
        Assertions.assertThat((Double)distanceMapBridge.get((Object)roadLocation)).isEqualTo(distance / 1000.0);
    }
}

