/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.vehiclerouting.plugin.planner;

import java.util.List;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.AdditionalAnswers;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Captor;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.junit.jupiter.MockitoSettings;
import org.mockito.quality.Strictness;
import org.mockito.verification.VerificationMode;
import org.optaplanner.core.api.score.buildin.hardsoftlong.HardSoftLongScore;
import org.optaplanner.core.api.solver.Solver;
import org.optaplanner.core.api.solver.event.BestSolutionChangedEvent;
import org.optaplanner.core.api.solver.event.SolverEventListener;
import org.optaplanner.core.impl.solver.ProblemFactChange;
import org.optaplanner.examples.vehiclerouting.domain.Customer;
import org.optaplanner.examples.vehiclerouting.domain.Depot;
import org.optaplanner.examples.vehiclerouting.domain.Standstill;
import org.optaplanner.examples.vehiclerouting.domain.VehicleRoutingSolution;
import org.optaplanner.examples.vehiclerouting.domain.location.RoadLocation;
import org.optaweb.vehiclerouting.domain.Coordinates;
import org.optaweb.vehiclerouting.domain.Location;
import org.optaweb.vehiclerouting.plugin.planner.RouteOptimizerImpl;
import org.optaweb.vehiclerouting.plugin.planner.SolutionUtil;
import org.optaweb.vehiclerouting.service.location.DistanceMatrix;
import org.optaweb.vehiclerouting.service.route.RouteChangedEvent;
import org.optaweb.vehiclerouting.service.route.ShallowRoute;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.core.task.AsyncTaskExecutor;

@ExtendWith(value={MockitoExtension.class})
@MockitoSettings(strictness=Strictness.WARN)
class RouteOptimizerImplTest {
    private final Location location1 = new Location(1L, Coordinates.valueOf((double)1.0, (double)0.1));
    private final Location location2 = new Location(2L, Coordinates.valueOf((double)0.2, (double)2.2));
    private final Location location3 = new Location(3L, Coordinates.valueOf((double)3.4, (double)5.6));
    private boolean isSolving;
    @Mock
    private ApplicationEventPublisher eventPublisher;
    @Mock
    private Solver<VehicleRoutingSolution> solver;
    @Mock
    private BestSolutionChangedEvent<VehicleRoutingSolution> bestSolutionChangedEvent;
    @Captor
    private ArgumentCaptor<RouteChangedEvent> routeChangedEventArgumentCaptor;
    @Mock
    private DistanceMatrix distanceMatrix;
    @Mock
    private AsyncTaskExecutor executor;
    @Mock
    private Future<VehicleRoutingSolution> solverFuture;
    @InjectMocks
    private RouteOptimizerImpl routeOptimizer;

    RouteOptimizerImplTest() {
    }

    @BeforeEach
    void setUp() {
        Mockito.when((Object)this.executor.submit((Callable)ArgumentMatchers.any(RouteOptimizerImpl.SolvingTask.class))).thenAnswer(AdditionalAnswers.answer(callable -> {
            callable.call();
            return this.solverFuture;
        }));
        this.isSolving = false;
        Mockito.when((Object)this.solver.isSolving()).thenAnswer(invocation -> this.isSolving);
        Mockito.when((Object)this.solver.solve(ArgumentMatchers.any())).thenAnswer(AdditionalAnswers.answerVoid(solution -> {
            this.isSolving = true;
        }));
        Mockito.when((Object)this.solver.terminateEarly()).thenAnswer(invocation -> {
            this.isSolving = false;
            return true;
        });
    }

    @Test
    void should_listen_for_best_solution_events() {
        ((Solver)Mockito.verify(this.solver)).addEventListener((SolverEventListener)this.routeOptimizer);
    }

    @Test
    void ignore_new_best_solutions_when_unprocessed_fact_changes() {
        Mockito.when((Object)this.bestSolutionChangedEvent.isEveryProblemFactChangeProcessed()).thenReturn((Object)false);
        this.routeOptimizer.bestSolutionChanged(this.bestSolutionChangedEvent);
        ((BestSolutionChangedEvent)Mockito.verify(this.bestSolutionChangedEvent, (VerificationMode)Mockito.never())).getNewBestSolution();
        ((ApplicationEventPublisher)Mockito.verify((Object)this.eventPublisher, (VerificationMode)Mockito.never())).publishEvent((ApplicationEvent)ArgumentMatchers.any());
    }

    @Test
    void publish_new_best_solution_if_all_fact_changes_processed() {
        VehicleRoutingSolution solution = RouteOptimizerImplTest.createSolution(this.location1, this.location2);
        Mockito.when((Object)this.bestSolutionChangedEvent.isEveryProblemFactChangeProcessed()).thenReturn((Object)true);
        Mockito.when((Object)this.bestSolutionChangedEvent.getNewBestSolution()).thenReturn((Object)solution);
        this.routeOptimizer.bestSolutionChanged(this.bestSolutionChangedEvent);
        ((ApplicationEventPublisher)Mockito.verify((Object)this.eventPublisher)).publishEvent((ApplicationEvent)this.routeChangedEventArgumentCaptor.capture());
        RouteChangedEvent event = (RouteChangedEvent)this.routeChangedEventArgumentCaptor.getValue();
        Assertions.assertThat((Optional)event.depot()).contains((Object)this.location1.id());
        Assertions.assertThat((Iterable)event.routes()).isNotEmpty();
        for (ShallowRoute route : event.routes()) {
            Assertions.assertThat((Long)route.depotId).isEqualTo(this.location1.id());
            Assertions.assertThat((List)route.visitIds).containsExactly((Object[])new Long[]{this.location2.id()});
        }
    }

    @Test
    void solution_with_depot_and_no_visits_should_be_published() {
        this.routeOptimizer.addLocation(this.location1, this.distanceMatrix);
        ((ApplicationEventPublisher)Mockito.verify((Object)this.eventPublisher)).publishEvent((ApplicationEvent)this.routeChangedEventArgumentCaptor.capture());
        RouteChangedEvent event = (RouteChangedEvent)this.routeChangedEventArgumentCaptor.getValue();
        Assertions.assertThat((boolean)this.solver.isSolving()).isFalse();
        Assertions.assertThat((Optional)event.depot()).contains((Object)this.location1.id());
        Assertions.assertThat((Iterable)event.routes()).hasSameSizeAs((Iterable)SolutionUtil.initialSolution().getVehicleList());
        for (ShallowRoute route : event.routes()) {
            Assertions.assertThat((Long)route.depotId).isEqualTo(this.location1.id());
            Assertions.assertThat((List)route.visitIds).isEmpty();
        }
    }

    @Test
    void solver_should_start_when_two_locations_added() {
        this.routeOptimizer.addLocation(this.location1, this.distanceMatrix);
        this.routeOptimizer.addLocation(this.location2, this.distanceMatrix);
        Assertions.assertThat((boolean)this.isSolving).isTrue();
        Assertions.assertThat((boolean)this.solver.isSolving()).isTrue();
        ((Solver)Mockito.verify(this.solver)).solve(ArgumentMatchers.any());
        ((Solver)Mockito.verify(this.solver, (VerificationMode)Mockito.never())).addProblemFactChange((ProblemFactChange)ArgumentMatchers.any());
    }

    @Test
    void solver_should_stop_when_locations_reduced_to_one() throws ExecutionException, InterruptedException {
        this.routeOptimizer.addLocation(this.location1, this.distanceMatrix);
        this.routeOptimizer.addLocation(this.location2, this.distanceMatrix);
        Assertions.assertThat((boolean)this.solver.isSolving()).isTrue();
        this.routeOptimizer.removeLocation(this.location2);
        Assertions.assertThat((boolean)this.solver.isSolving()).isFalse();
        ((Solver)Mockito.verify(this.solver)).terminateEarly();
        ((Future)Mockito.verify(this.solverFuture)).get();
        ((Solver)Mockito.verify(this.solver, (VerificationMode)Mockito.never())).addProblemFactChange((ProblemFactChange)ArgumentMatchers.any());
    }

    @Test
    void solution_update_event_should_only_have_empty_routes_when_last_visit_removed() {
        VehicleRoutingSolution solution = SolutionUtil.emptySolution();
        Depot depot = SolutionUtil.addDepot((VehicleRoutingSolution)solution, (org.optaplanner.examples.vehiclerouting.domain.location.Location)SolutionUtil.planningLocation((Location)this.location1));
        SolutionUtil.addVehicle((VehicleRoutingSolution)solution, (long)1L);
        SolutionUtil.addVehicle((VehicleRoutingSolution)solution, (long)2L);
        SolutionUtil.moveAllVehiclesTo((VehicleRoutingSolution)solution, (Depot)depot);
        Customer customer = SolutionUtil.addCustomer((VehicleRoutingSolution)solution, (org.optaplanner.examples.vehiclerouting.domain.location.Location)SolutionUtil.planningLocation((Location)this.location2));
        solution.getVehicleList().forEach(vehicle -> vehicle.setNextCustomer(customer));
        Assertions.assertThat((List)SolutionUtil.routes((VehicleRoutingSolution)solution)).allMatch(shallowRoute -> shallowRoute.visitIds.size() == 1);
        solution.setScore(HardSoftLongScore.ofSoft((long)-1000L));
        this.routeOptimizer.addLocation(this.location1, this.distanceMatrix);
        this.routeOptimizer.addLocation(this.location2, this.distanceMatrix);
        Mockito.when((Object)this.bestSolutionChangedEvent.isEveryProblemFactChangeProcessed()).thenReturn((Object)true);
        Mockito.when((Object)this.bestSolutionChangedEvent.getNewBestSolution()).thenReturn((Object)solution);
        this.routeOptimizer.bestSolutionChanged(this.bestSolutionChangedEvent);
        Mockito.clearInvocations((Object[])new ApplicationEventPublisher[]{this.eventPublisher});
        this.routeOptimizer.removeLocation(this.location2);
        Assertions.assertThat((boolean)this.routeOptimizer.isSolving()).isFalse();
        ((ApplicationEventPublisher)Mockito.verify((Object)this.eventPublisher)).publishEvent((ApplicationEvent)this.routeChangedEventArgumentCaptor.capture());
        RouteChangedEvent event = (RouteChangedEvent)this.routeChangedEventArgumentCaptor.getValue();
        Assertions.assertThat((String)event.distance()).isEqualTo((Object)"0h 0m 0s");
        Assertions.assertThat((Optional)event.depot()).isPresent();
        Assertions.assertThat((Iterable)event.routes()).hasSameSizeAs((Iterable)solution.getVehicleList());
        for (ShallowRoute route : event.routes()) {
            Assertions.assertThat((List)route.visitIds).isEmpty();
        }
    }

    @Test
    void removing_depot_impossible_when_there_are_other_locations() {
        this.routeOptimizer.addLocation(this.location1, this.distanceMatrix);
        this.routeOptimizer.addLocation(this.location2, this.distanceMatrix);
        Assertions.assertThatIllegalStateException().isThrownBy(() -> this.routeOptimizer.removeLocation(this.location1)).withMessageContaining("depot");
    }

    @Test
    void adding_location_to_running_solver_must_happen_through_problem_fact_change() {
        this.routeOptimizer.addLocation(this.location1, this.distanceMatrix);
        Assertions.assertThat((boolean)this.solver.isSolving()).isFalse();
        this.routeOptimizer.addLocation(this.location2, this.distanceMatrix);
        Assertions.assertThat((boolean)this.solver.isSolving()).isTrue();
        this.routeOptimizer.addLocation(this.location3, this.distanceMatrix);
        ((Solver)Mockito.verify(this.solver)).addProblemFactChange((ProblemFactChange)ArgumentMatchers.any());
    }

    @Test
    void removing_location_from_solver_with_more_than_two_locations_must_happen_through_problem_fact_change() {
        VehicleRoutingSolution solution = RouteOptimizerImplTest.createSolution(this.location1, this.location2, this.location3);
        Mockito.when((Object)this.bestSolutionChangedEvent.isEveryProblemFactChangeProcessed()).thenReturn((Object)true);
        Mockito.when((Object)this.bestSolutionChangedEvent.getNewBestSolution()).thenReturn((Object)solution);
        this.routeOptimizer.addLocation(this.location1, this.distanceMatrix);
        this.routeOptimizer.addLocation(this.location2, this.distanceMatrix);
        this.routeOptimizer.addLocation(this.location3, this.distanceMatrix);
        this.routeOptimizer.bestSolutionChanged(this.bestSolutionChangedEvent);
        this.routeOptimizer.removeLocation(this.location2);
        ((Solver)Mockito.verify(this.solver)).addProblemFactChanges((List)ArgumentMatchers.any());
        ((Solver)Mockito.verify(this.solver, (VerificationMode)Mockito.never())).terminateEarly();
    }

    @Test
    void clear_should_stop_solver_and_publish_initial_solution() throws ExecutionException, InterruptedException {
        VehicleRoutingSolution solution = RouteOptimizerImplTest.createSolution(this.location1, this.location2, this.location3);
        Mockito.when((Object)this.bestSolutionChangedEvent.isEveryProblemFactChangeProcessed()).thenReturn((Object)true);
        Mockito.when((Object)this.bestSolutionChangedEvent.getNewBestSolution()).thenReturn((Object)solution);
        this.routeOptimizer.addLocation(this.location1, this.distanceMatrix);
        this.routeOptimizer.addLocation(this.location2, this.distanceMatrix);
        this.routeOptimizer.addLocation(this.location3, this.distanceMatrix);
        this.routeOptimizer.bestSolutionChanged(this.bestSolutionChangedEvent);
        Mockito.clearInvocations((Object[])new ApplicationEventPublisher[]{this.eventPublisher});
        this.routeOptimizer.clear();
        Assertions.assertThat((boolean)this.solver.isSolving()).isFalse();
        ((Solver)Mockito.verify(this.solver)).terminateEarly();
        ((Future)Mockito.verify(this.solverFuture)).get();
        ((ApplicationEventPublisher)Mockito.verify((Object)this.eventPublisher)).publishEvent((ApplicationEvent)this.routeChangedEventArgumentCaptor.capture());
        RouteChangedEvent event = (RouteChangedEvent)this.routeChangedEventArgumentCaptor.getValue();
        Assertions.assertThat((Optional)event.depot()).isEmpty();
        Assertions.assertThat((Iterable)event.routes()).isEmpty();
    }

    @Test
    void clear_should_not_fail_when_solver_is_not_solving() {
        Assertions.assertThatCode(() -> this.routeOptimizer.clear()).doesNotThrowAnyException();
    }

    @Test
    void reset_interrupted_flag() throws ExecutionException, InterruptedException {
        Mockito.when((Object)this.solverFuture.isDone()).thenReturn((Object)true);
        Mockito.when((Object)this.solverFuture.get()).thenThrow(InterruptedException.class);
        this.routeOptimizer.addLocation(this.location1, this.distanceMatrix);
        this.routeOptimizer.addLocation(this.location2, this.distanceMatrix);
        Assertions.assertThatExceptionOfType(RuntimeException.class).isThrownBy(() -> this.routeOptimizer.removeLocation(this.location2));
        Assertions.assertThat((boolean)Thread.interrupted()).isTrue();
        Assertions.assertThatExceptionOfType(RuntimeException.class).isThrownBy(() -> this.routeOptimizer.clear());
        Assertions.assertThat((boolean)Thread.interrupted()).isTrue();
    }

    @Test
    void planning_location_should_have_same_latitude_and_longitude() {
        RoadLocation roadLocation = SolutionUtil.planningLocation((Location)this.location1);
        Assertions.assertThat((Long)roadLocation.getId()).isEqualTo(this.location1.id());
        Assertions.assertThat((double)roadLocation.getLatitude()).isEqualTo(this.location1.coordinates().latitude().doubleValue());
        Assertions.assertThat((double)roadLocation.getLongitude()).isEqualTo(this.location1.coordinates().longitude().doubleValue());
    }

    private static VehicleRoutingSolution createSolution(Location ... domainLocations) {
        VehicleRoutingSolution solution = SolutionUtil.emptySolution();
        Depot depot = SolutionUtil.addDepot((VehicleRoutingSolution)solution, (org.optaplanner.examples.vehiclerouting.domain.location.Location)SolutionUtil.planningLocation((Location)domainLocations[0]));
        SolutionUtil.addVehicle((VehicleRoutingSolution)solution, (long)1L);
        SolutionUtil.moveAllVehiclesTo((VehicleRoutingSolution)solution, (Depot)depot);
        for (int i = 1; i < domainLocations.length; ++i) {
            SolutionUtil.addCustomer((VehicleRoutingSolution)solution, (org.optaplanner.examples.vehiclerouting.domain.location.Location)SolutionUtil.planningLocation((Location)domainLocations[i]));
        }
        Standstill previousStandstill = (Standstill)solution.getVehicleList().get(0);
        for (Customer customer : solution.getCustomerList()) {
            customer.setPreviousStandstill(previousStandstill);
            previousStandstill.setNextCustomer(customer);
            previousStandstill = customer;
        }
        return solution;
    }
}

