/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.vehiclerouting.plugin.planner;

import java.util.List;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.junit.jupiter.api.Test;
import org.optaplanner.examples.vehiclerouting.domain.Customer;
import org.optaplanner.examples.vehiclerouting.domain.Depot;
import org.optaplanner.examples.vehiclerouting.domain.Standstill;
import org.optaplanner.examples.vehiclerouting.domain.Vehicle;
import org.optaplanner.examples.vehiclerouting.domain.VehicleRoutingSolution;
import org.optaplanner.examples.vehiclerouting.domain.location.Location;
import org.optaplanner.examples.vehiclerouting.domain.location.RoadLocation;
import org.optaweb.vehiclerouting.plugin.planner.SolutionUtil;
import org.optaweb.vehiclerouting.service.route.ShallowRoute;

class SolutionUtilTest {
    SolutionUtilTest() {
    }

    @Test
    void empty_solution_should_be_empty() {
        VehicleRoutingSolution solution = SolutionUtil.emptySolution();
        Assertions.assertThat((List)solution.getLocationList()).isEmpty();
        Assertions.assertThat((List)solution.getCustomerList()).isEmpty();
        Assertions.assertThat((List)solution.getDepotList()).isEmpty();
        Assertions.assertThat((List)solution.getVehicleList()).isEmpty();
    }

    @Test
    void adding_depot_should_create_depot_and_add_location() {
        VehicleRoutingSolution solution = SolutionUtil.emptySolution();
        RoadLocation roadLocation = new RoadLocation(1L, 1.0, 1.0);
        Depot depot = SolutionUtil.addDepot((VehicleRoutingSolution)solution, (Location)roadLocation);
        Assertions.assertThat((List)solution.getLocationList()).containsExactly((Object[])new Location[]{roadLocation});
        Assertions.assertThat((List)solution.getDepotList()).containsExactly((Object[])new Depot[]{depot});
        Assertions.assertThat((Comparable)((Depot)solution.getDepotList().get(0)).getLocation()).isSameAs((Object)roadLocation);
    }

    @Test
    void move_all_vehicles_to_a_depot() {
        VehicleRoutingSolution solution = SolutionUtil.emptySolution();
        RoadLocation roadLocation = new RoadLocation(1L, 1.0, 1.0);
        Depot depot = SolutionUtil.addDepot((VehicleRoutingSolution)solution, (Location)roadLocation);
        SolutionUtil.addVehicle((VehicleRoutingSolution)solution, (long)1L);
        SolutionUtil.addVehicle((VehicleRoutingSolution)solution, (long)2L);
        SolutionUtil.moveAllVehiclesTo((VehicleRoutingSolution)solution, (Depot)depot);
        Assertions.assertThat((List)solution.getVehicleList()).allMatch(vehicle -> vehicle.getDepot() == depot);
    }

    @Test
    void adding_customer_should_create_customer_and_add_location() {
        VehicleRoutingSolution solution = SolutionUtil.emptySolution();
        RoadLocation roadLocation = new RoadLocation(1L, 1.0, 1.0);
        Customer customer = SolutionUtil.addCustomer((VehicleRoutingSolution)solution, (Location)roadLocation);
        Assertions.assertThat((int)customer.getDemand()).isEqualTo(0);
        Assertions.assertThat((List)solution.getLocationList()).containsExactly((Object[])new Location[]{roadLocation});
        Assertions.assertThat((List)solution.getCustomerList()).containsExactly((Object[])new Customer[]{customer});
        Assertions.assertThat((Comparable)((Customer)solution.getCustomerList().get(0)).getLocation()).isSameAs((Object)roadLocation);
    }

    @Test
    void empty_solution_should_have_zero_routes() {
        VehicleRoutingSolution solution = SolutionUtil.emptySolution();
        List routes = SolutionUtil.routes((VehicleRoutingSolution)solution);
        Assertions.assertThat((List)routes).isEmpty();
    }

    @Test
    void nonempty_uninitialized_solution_should_have_zero_routes() {
        VehicleRoutingSolution solution = SolutionUtil.emptySolution();
        SolutionUtil.addDepot((VehicleRoutingSolution)solution, (Location)new RoadLocation(1L, 1.0, 1.0));
        SolutionUtil.addCustomer((VehicleRoutingSolution)solution, (Location)new RoadLocation(2L, 2.0, 2.0));
        List routes = SolutionUtil.routes((VehicleRoutingSolution)solution);
        Assertions.assertThat((List)routes).isEmpty();
    }

    @Test
    void initialized_solution_should_have_one_route_per_vehicle() {
        VehicleRoutingSolution solution = SolutionUtil.emptySolution();
        SolutionUtil.addVehicle((VehicleRoutingSolution)solution, (long)1L);
        SolutionUtil.addVehicle((VehicleRoutingSolution)solution, (long)2L);
        Depot depot = SolutionUtil.addDepot((VehicleRoutingSolution)solution, (Location)new RoadLocation(1L, 1.0, 1.0));
        Customer customer = SolutionUtil.addCustomer((VehicleRoutingSolution)solution, (Location)new RoadLocation(2L, 2.0, 2.0));
        for (Vehicle vehicle : solution.getVehicleList()) {
            vehicle.setDepot(depot);
            vehicle.setNextCustomer(customer);
            customer.setPreviousStandstill((Standstill)vehicle);
        }
        List routes = SolutionUtil.routes((VehicleRoutingSolution)solution);
        Assertions.assertThat((List)routes).hasSameSizeAs((Iterable)solution.getVehicleList());
        for (ShallowRoute route : routes) {
            Assertions.assertThat((Long)route.depotId).isEqualTo((Object)depot.getId());
            ((ListAssert)Assertions.assertThat((List)route.visitIds).hasSize(1)).doesNotContain((Object[])new Long[]{depot.getId()});
        }
    }

    @Test
    void vehicle_without_a_depot_is_illegal() {
        VehicleRoutingSolution solution = SolutionUtil.emptySolution();
        SolutionUtil.addDepot((VehicleRoutingSolution)solution, (Location)new RoadLocation(1L, 1.0, 1.0));
        SolutionUtil.addVehicle((VehicleRoutingSolution)solution, (long)1L);
        Assertions.assertThatIllegalStateException().isThrownBy(() -> SolutionUtil.routes((VehicleRoutingSolution)solution));
    }

    @Test
    void fail_fast_if_vehicles_next_customer_doesnt_exist() {
        VehicleRoutingSolution solution = SolutionUtil.emptySolution();
        Depot depot = SolutionUtil.addDepot((VehicleRoutingSolution)solution, (Location)new RoadLocation(1L, 1.0, 1.0));
        Vehicle vehicle = SolutionUtil.addVehicle((VehicleRoutingSolution)solution, (long)1L);
        SolutionUtil.moveAllVehiclesTo((VehicleRoutingSolution)solution, (Depot)depot);
        Customer customer = SolutionUtil.addCustomer((VehicleRoutingSolution)solution, (Location)new RoadLocation(2L, 2.0, 2.0));
        vehicle.setNextCustomer(customer);
        solution.getCustomerList().clear();
        solution.getLocationList().clear();
        Assertions.assertThatIllegalStateException().isThrownBy(() -> SolutionUtil.routes((VehicleRoutingSolution)solution));
    }
}

