/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.vehiclerouting.plugin.planner;

import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ThrowableAssert;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentMatchers;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.optaplanner.core.api.solver.Solver;
import org.optaplanner.examples.tsp.domain.TspSolution;
import org.optaweb.vehiclerouting.domain.Coordinates;
import org.optaweb.vehiclerouting.domain.Location;
import org.optaweb.vehiclerouting.plugin.planner.RouteOptimizerImpl;
import org.optaweb.vehiclerouting.service.location.DistanceMatrix;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.core.task.AsyncTaskExecutor;

@ExtendWith(value={MockitoExtension.class})
class SolverExceptionTest {
    private final Location location1 = new Location(1L, Coordinates.valueOf((double)1.0, (double)0.1));
    private final Location location2 = new Location(2L, Coordinates.valueOf((double)0.2, (double)2.2));
    private final Location location3 = new Location(3L, Coordinates.valueOf((double)3.4, (double)5.6));
    @Mock
    private ApplicationEventPublisher eventPublisher;
    @Mock
    private Solver<TspSolution> solver;
    @Mock
    private DistanceMatrix distanceMatrix;
    @Mock
    private AsyncTaskExecutor executor;
    @InjectMocks
    private RouteOptimizerImpl routeOptimizer;

    SolverExceptionTest() {
    }

    @Test
    void should_propagate_any_exception_from_solver() {
        FutureTask<Object> task = new FutureTask<Object>(() -> {
            throw new TestException();
        }, null);
        Mockito.when((Object)this.executor.submit((Callable)ArgumentMatchers.any(RouteOptimizerImpl.SolvingTask.class))).thenReturn(task);
        task.run();
        this.routeOptimizer.addLocation(this.location1, this.distanceMatrix);
        Assertions.assertThat((boolean)this.routeOptimizer.isSolving()).isFalse();
        this.routeOptimizer.addLocation(this.location2, this.distanceMatrix);
        SolverExceptionTest.assertTestExceptionThrownDuringOperation(() -> this.routeOptimizer.isSolving());
        SolverExceptionTest.assertTestExceptionThrownDuringOperation(() -> this.routeOptimizer.addLocation(this.location3, this.distanceMatrix));
        SolverExceptionTest.assertTestExceptionThrownDuringOperation(() -> this.routeOptimizer.removeLocation(this.location2));
        SolverExceptionTest.assertTestExceptionThrownWhenStoppingSolver(this.routeOptimizer);
    }

    private static void assertTestExceptionThrownDuringOperation(ThrowableAssert.ThrowingCallable runnable) {
        SolverExceptionTest.assertTestExceptionThrownDuring(runnable, "died");
    }

    private static void assertTestExceptionThrownWhenStoppingSolver(RouteOptimizerImpl routeOptimizer) {
        SolverExceptionTest.assertTestExceptionThrownDuring(() -> ((RouteOptimizerImpl)routeOptimizer).stopSolver(), "stop");
    }

    private static void assertTestExceptionThrownDuring(ThrowableAssert.ThrowingCallable runnable, String message) {
        Assertions.assertThatExceptionOfType(RuntimeException.class).isThrownBy(runnable).withMessageContaining(message).withRootCauseExactlyInstanceOf(TestException.class);
    }

    private static class TestException
    extends RuntimeException {
        private TestException() {
        }
    }
}

