/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.vehiclerouting.plugin.planner;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.optaplanner.core.api.solver.Solver;
import org.optaplanner.core.api.solver.SolverFactory;
import org.optaplanner.core.api.solver.event.BestSolutionChangedEvent;
import org.optaplanner.core.api.solver.event.SolverEventListener;
import org.optaplanner.core.impl.solver.ProblemFactChange;
import org.optaplanner.examples.vehiclerouting.domain.Depot;
import org.optaplanner.examples.vehiclerouting.domain.VehicleRoutingSolution;
import org.optaplanner.examples.vehiclerouting.domain.location.Location;
import org.optaplanner.examples.vehiclerouting.domain.location.RoadLocation;
import org.optaweb.vehiclerouting.plugin.planner.SolutionUtil;
import org.optaweb.vehiclerouting.plugin.planner.change.AddCustomer;
import org.optaweb.vehiclerouting.plugin.planner.change.RemoveCustomer;
import org.optaweb.vehiclerouting.plugin.planner.change.RemoveLocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ExtendWith(value={MockitoExtension.class})
class SolverIntegrationTest {
    private static final Logger logger = LoggerFactory.getLogger(SolverIntegrationTest.class);
    @Mock
    private Map<RoadLocation, Double> distanceMap;
    private SolverFactory<VehicleRoutingSolution> sf;
    private ExecutorService executor;
    private ProblemFactChangeProcessingMonitor monitor;
    private Future<VehicleRoutingSolution> futureSolution;

    SolverIntegrationTest() {
    }

    @BeforeEach
    void setUp() {
        this.sf = SolverFactory.createFromXmlResource((String)"org/optaplanner/examples/vehiclerouting/solver/vehicleRoutingSolverConfig.xml");
        this.executor = Executors.newSingleThreadExecutor();
        this.monitor = new ProblemFactChangeProcessingMonitor();
        Mockito.when((Object)this.distanceMap.get(Mockito.any(RoadLocation.class))).thenReturn((Object)1.0);
    }

    @AfterEach
    void tearDown() throws InterruptedException {
        this.executor.shutdown();
        this.executor.awaitTermination(1L, TimeUnit.SECONDS);
    }

    @Disabled(value="Solver fails fast on empty value ranges")
    @Test
    void solver_in_daemon_mode_should_not_fail_on_empty_solution() {
        this.sf.getSolverConfig().setDaemon(Boolean.valueOf(true));
        Assertions.assertThat((Comparable)((Comparable)this.sf.buildSolver().solve((Object)SolutionUtil.emptySolution()))).isNotNull();
    }

    @Test
    void removing_customers_should_not_fail() {
        VehicleRoutingSolution solution = SolutionUtil.emptySolution();
        Depot depot = SolutionUtil.addDepot((VehicleRoutingSolution)solution, (Location)this.location(1L));
        SolutionUtil.addVehicle((VehicleRoutingSolution)solution, (long)1L);
        SolutionUtil.moveAllVehiclesTo((VehicleRoutingSolution)solution, (Depot)depot);
        SolutionUtil.addCustomer((VehicleRoutingSolution)solution, (Location)this.location(2L));
        this.sf.getSolverConfig().setDaemon(Boolean.valueOf(true));
        Solver solver = this.sf.buildSolver();
        solver.addEventListener((SolverEventListener)this.monitor);
        this.startSolver((Solver<VehicleRoutingSolution>)solver, solution);
        for (int id = 3; id < 6; ++id) {
            logger.info("Add customer ({})", (Object)id);
            this.monitor.beforeProblemFactChange();
            solver.addProblemFactChange((ProblemFactChange)new AddCustomer(this.location(id)));
            Assertions.assertThat((boolean)this.monitor.awaitAllProblemFactChanges(1000)).isTrue();
        }
        List<Integer> customerIds = Arrays.asList(5, 2, 3);
        for (int id : customerIds) {
            logger.info("Remove customer ({})", (Object)id);
            Location removeLocation = this.location(id);
            Assertions.assertThat((boolean)solver.isEveryProblemFactChangeProcessed()).isTrue();
            this.monitor.beforeProblemFactChange();
            solver.addProblemFactChanges(Arrays.asList(new RemoveCustomer(removeLocation), new RemoveLocation(removeLocation)));
            Assertions.assertThat((boolean)solver.isEveryProblemFactChangeProcessed()).isFalse();
            if (this.monitor.awaitAllProblemFactChanges(1000)) continue;
            Assertions.assertThat((Comparable)this.terminateSolver((Solver<VehicleRoutingSolution>)solver)).isNotNull();
            Assertions.fail((String)"Problem fact change hasn't been completed.");
        }
        Assertions.assertThat((Comparable)this.terminateSolver((Solver<VehicleRoutingSolution>)solver)).isNotNull();
    }

    private void startSolver(Solver<VehicleRoutingSolution> solver, VehicleRoutingSolution solution) {
        this.futureSolution = this.executor.submit(() -> (VehicleRoutingSolution)solver.solve((Object)solution));
    }

    private VehicleRoutingSolution terminateSolver(Solver<VehicleRoutingSolution> solver) {
        solver.terminateEarly();
        try {
            return this.futureSolution.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            Assertions.fail((String)"Interrupted", (Throwable)e);
        }
        catch (ExecutionException e) {
            Assertions.fail((String)"Solving failed", (Throwable)e);
        }
        throw new AssertionError();
    }

    private Location location(long id) {
        RoadLocation location = new RoadLocation();
        location.setId(Long.valueOf(id));
        location.setTravelDistanceMap(this.distanceMap);
        return location;
    }

    static class ProblemFactChangeProcessingMonitor
    implements SolverEventListener<VehicleRoutingSolution> {
        private static final Logger logger = LoggerFactory.getLogger(ProblemFactChangeProcessingMonitor.class);
        private final Semaphore problemFactChanges = new Semaphore(0);

        ProblemFactChangeProcessingMonitor() {
        }

        void beforeProblemFactChange() {
            int permitsDrained = this.problemFactChanges.drainPermits();
            logger.debug("Before PFC (permits drained: {})", (Object)permitsDrained);
        }

        boolean awaitAllProblemFactChanges(int milliseconds) {
            logger.debug("WAIT (completed PFCs: {})", (Object)this.problemFactChanges.availablePermits());
            try {
                if (this.problemFactChanges.tryAcquire(milliseconds, TimeUnit.MILLISECONDS)) {
                    logger.info("Problem Fact Change DONE");
                    return true;
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                Assertions.fail((String)"Interrupted", (Throwable)e);
            }
            return false;
        }

        public void bestSolutionChanged(BestSolutionChangedEvent<VehicleRoutingSolution> event) {
            if (!event.isEveryProblemFactChangeProcessed()) {
                logger.debug("UNPROCESSED");
            } else if (!event.getNewBestScore().isSolutionInitialized()) {
                logger.debug("UNINITIALIZED ({})", (Object)event.getNewBestScore());
            } else {
                logger.debug("New best solution (COMPLETE)");
                this.problemFactChanges.release();
            }
        }
    }
}

