/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.vehiclerouting.plugin.planner.change;

import java.util.List;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.optaplanner.core.impl.score.director.ScoreDirector;
import org.optaplanner.examples.vehiclerouting.domain.Customer;
import org.optaplanner.examples.vehiclerouting.domain.Standstill;
import org.optaplanner.examples.vehiclerouting.domain.Vehicle;
import org.optaplanner.examples.vehiclerouting.domain.VehicleRoutingSolution;
import org.optaplanner.examples.vehiclerouting.domain.location.Location;
import org.optaplanner.examples.vehiclerouting.domain.location.RoadLocation;
import org.optaweb.vehiclerouting.plugin.planner.SolutionUtil;
import org.optaweb.vehiclerouting.plugin.planner.change.RemoveCustomer;

@ExtendWith(value={MockitoExtension.class})
class RemoveCustomerTest {
    @Mock
    private ScoreDirector<VehicleRoutingSolution> scoreDirector;

    RemoveCustomerTest() {
    }

    @Test
    void remove_last_customer() {
        VehicleRoutingSolution solution = SolutionUtil.emptySolution();
        Mockito.when((Object)this.scoreDirector.getWorkingSolution()).thenReturn((Object)solution);
        Customer removedCustomer = RemoveCustomerTest.customer(1L);
        Customer otherCustomer = RemoveCustomerTest.customer(2L);
        solution.getCustomerList().add(otherCustomer);
        solution.getCustomerList().add(removedCustomer);
        otherCustomer.setPreviousStandstill((Standstill)new Vehicle());
        otherCustomer.setNextCustomer(removedCustomer);
        removedCustomer.setPreviousStandstill((Standstill)otherCustomer);
        RemoveCustomer removeCustomer = new RemoveCustomer(removedCustomer.getLocation());
        removeCustomer.doChange(this.scoreDirector);
        ((ScoreDirector)Mockito.verify(this.scoreDirector)).beforeEntityRemoved(ArgumentMatchers.any(Customer.class));
        ((ScoreDirector)Mockito.verify(this.scoreDirector)).afterEntityRemoved(ArgumentMatchers.any(Customer.class));
        Assertions.assertThat((List)solution.getCustomerList()).containsExactly((Object[])new Customer[]{otherCustomer});
        ((ScoreDirector)Mockito.verify(this.scoreDirector)).triggerVariableListeners();
    }

    @Test
    void remove_middle_customer() {
        VehicleRoutingSolution solution = SolutionUtil.emptySolution();
        Mockito.when((Object)this.scoreDirector.getWorkingSolution()).thenReturn((Object)solution);
        Customer firstCustomer = RemoveCustomerTest.customer(1L);
        Customer removedCustomer = RemoveCustomerTest.customer(2L);
        Customer lastCustomer = RemoveCustomerTest.customer(3L);
        solution.getCustomerList().add(firstCustomer);
        solution.getCustomerList().add(lastCustomer);
        solution.getCustomerList().add(removedCustomer);
        firstCustomer.setPreviousStandstill((Standstill)new Vehicle());
        firstCustomer.setNextCustomer(removedCustomer);
        removedCustomer.setPreviousStandstill((Standstill)firstCustomer);
        removedCustomer.setNextCustomer(lastCustomer);
        lastCustomer.setPreviousStandstill((Standstill)removedCustomer);
        RemoveCustomer removeCustomer = new RemoveCustomer(removedCustomer.getLocation());
        removeCustomer.doChange(this.scoreDirector);
        ((ScoreDirector)Mockito.verify(this.scoreDirector)).beforeVariableChanged(ArgumentMatchers.any(Customer.class), ArgumentMatchers.anyString());
        ((ScoreDirector)Mockito.verify(this.scoreDirector)).afterVariableChanged(ArgumentMatchers.any(Customer.class), ArgumentMatchers.anyString());
        ((ScoreDirector)Mockito.verify(this.scoreDirector)).beforeEntityRemoved(ArgumentMatchers.any(Customer.class));
        ((ScoreDirector)Mockito.verify(this.scoreDirector)).afterEntityRemoved(ArgumentMatchers.any(Customer.class));
        ((ListAssert)Assertions.assertThat((List)solution.getCustomerList()).hasSize(2)).containsOnly((Object[])new Customer[]{firstCustomer, lastCustomer});
        Assertions.assertThat((Object)lastCustomer.getPreviousStandstill()).isEqualTo((Object)firstCustomer);
        ((ScoreDirector)Mockito.verify(this.scoreDirector)).triggerVariableListeners();
    }

    private static Customer customer(long id) {
        RoadLocation location = new RoadLocation(1000000L + id, (double)id, (double)id);
        Customer customer = new Customer();
        customer.setId(Long.valueOf(id));
        customer.setLocation((Location)location);
        return customer;
    }
}

