/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.vehiclerouting.plugin.planner.change;

import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.optaplanner.core.impl.score.director.ScoreDirector;
import org.optaplanner.examples.vehiclerouting.domain.VehicleRoutingSolution;
import org.optaplanner.examples.vehiclerouting.domain.location.Location;
import org.optaplanner.examples.vehiclerouting.domain.location.RoadLocation;
import org.optaweb.vehiclerouting.plugin.planner.SolutionUtil;
import org.optaweb.vehiclerouting.plugin.planner.change.RemoveLocation;

@ExtendWith(value={MockitoExtension.class})
class RemoveLocationTest {
    @Mock
    private ScoreDirector<VehicleRoutingSolution> scoreDirector;

    RemoveLocationTest() {
    }

    @Test
    void remove_location() {
        VehicleRoutingSolution solution = SolutionUtil.emptySolution();
        Mockito.when((Object)this.scoreDirector.getWorkingSolution()).thenReturn((Object)solution);
        RoadLocation location = new RoadLocation(1L, 2.0, 3.0);
        solution.getLocationList().add(location);
        Mockito.when((Object)this.scoreDirector.lookUpWorkingObject((Object)location)).thenReturn((Object)location);
        RemoveLocation removeLocation = new RemoveLocation((Location)location);
        removeLocation.doChange(this.scoreDirector);
        ((ScoreDirector)Mockito.verify(this.scoreDirector)).beforeProblemFactRemoved((Object)location);
        ((ScoreDirector)Mockito.verify(this.scoreDirector)).afterProblemFactRemoved((Object)location);
        Assertions.assertThat((List)solution.getLocationList()).isEmpty();
        ((ScoreDirector)Mockito.verify(this.scoreDirector)).triggerVariableListeners();
    }
}

