/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.vehiclerouting.plugin.websocket;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.optaweb.vehiclerouting.domain.Coordinates;
import org.optaweb.vehiclerouting.domain.Location;
import org.optaweb.vehiclerouting.domain.LocationData;
import org.optaweb.vehiclerouting.domain.RouteWithTrack;
import org.optaweb.vehiclerouting.domain.RoutingPlan;
import org.optaweb.vehiclerouting.domain.RoutingProblem;
import org.optaweb.vehiclerouting.plugin.websocket.PortableCoordinates;
import org.optaweb.vehiclerouting.plugin.websocket.PortableLocation;
import org.optaweb.vehiclerouting.plugin.websocket.PortableRoutingPlan;
import org.optaweb.vehiclerouting.plugin.websocket.RoutingProblemInfo;
import org.optaweb.vehiclerouting.plugin.websocket.ServerInfo;
import org.optaweb.vehiclerouting.plugin.websocket.WebSocketController;
import org.optaweb.vehiclerouting.service.demo.DemoService;
import org.optaweb.vehiclerouting.service.location.LocationService;
import org.optaweb.vehiclerouting.service.region.BoundingBox;
import org.optaweb.vehiclerouting.service.region.RegionService;
import org.optaweb.vehiclerouting.service.route.RouteListener;

@ExtendWith(value={MockitoExtension.class})
class WebSocketControllerTest {
    @Mock
    private RouteListener routeListener;
    @Mock
    private RegionService regionService;
    @Mock
    private LocationService locationService;
    @Mock
    private DemoService demoService;
    @InjectMocks
    private WebSocketController webSocketController;

    WebSocketControllerTest() {
    }

    @Test
    void subscribeToRouteTopic() {
        String distance = "some distance";
        Location depot = new Location(1L, Coordinates.valueOf((double)3.0, (double)5.0));
        List<Object> routes = Collections.singletonList(Mockito.mock(RouteWithTrack.class));
        RoutingPlan plan = new RoutingPlan(distance, depot, routes);
        Mockito.when((Object)this.routeListener.getBestRoutingPlan()).thenReturn((Object)plan);
        PortableRoutingPlan portableRoutingPlan = this.webSocketController.subscribeToRouteTopic();
        Assertions.assertThat((String)portableRoutingPlan.getDistance()).isEqualTo((Object)distance);
        Assertions.assertThat((Object)portableRoutingPlan.getDepot()).isEqualTo((Object)PortableLocation.fromLocation((Location)depot));
        Assertions.assertThat((List)portableRoutingPlan.getRoutes()).hasSize(1);
    }

    @Test
    void subscribeToServerInfo() {
        List<String> countryCodes = Arrays.asList("XY", "WZ");
        Mockito.when((Object)this.regionService.countryCodes()).thenReturn(countryCodes);
        Coordinates southWest = Coordinates.valueOf((double)-1.0, (double)-2.0);
        Coordinates northEast = Coordinates.valueOf((double)1.0, (double)2.0);
        BoundingBox boundingBox = new BoundingBox(southWest, northEast);
        Mockito.when((Object)this.regionService.boundingBox()).thenReturn((Object)boundingBox);
        Location depot = new Location(1L, Coordinates.valueOf((double)1.0, (double)7.0), "Depot");
        List<Location> visits = Arrays.asList(new Location(2L, Coordinates.valueOf((double)2.0, (double)9.0), "Visit"));
        String demoName = "Testing problem";
        RoutingProblem routingProblem = new RoutingProblem(demoName, (LocationData)depot, visits);
        Mockito.when((Object)this.demoService.demos()).thenReturn(Arrays.asList(routingProblem));
        ServerInfo serverInfo = this.webSocketController.subscribeToServerInfoTopic();
        Assertions.assertThat((List)serverInfo.getCountryCodes()).isEqualTo(countryCodes);
        Assertions.assertThat((List)serverInfo.getBoundingBox()).containsExactly((Object[])new PortableCoordinates[]{PortableCoordinates.fromCoordinates((Coordinates)southWest), PortableCoordinates.fromCoordinates((Coordinates)northEast)});
        List demos = serverInfo.getDemos();
        Assertions.assertThat((List)demos).hasSize(1);
        RoutingProblemInfo demo = (RoutingProblemInfo)demos.get(0);
        Assertions.assertThat((String)demo.getName()).isEqualTo((Object)demoName);
        Assertions.assertThat((int)demo.getVisits()).isEqualTo(visits.size());
    }

    @Test
    void addLocation() {
        Coordinates coords = Coordinates.valueOf((double)0.0, (double)1.0);
        String description = "new location";
        PortableLocation request = new PortableLocation(321L, coords.latitude(), coords.longitude(), description);
        this.webSocketController.addLocation(request);
        ((LocationService)Mockito.verify((Object)this.locationService)).createLocation(coords, description);
    }

    @Test
    void removeLocation() {
        this.webSocketController.removeLocation(Long.valueOf(9L));
        ((LocationService)Mockito.verify((Object)this.locationService)).removeLocation(9L);
    }

    @Test
    void demo() {
        String problemName = "xy";
        this.webSocketController.demo(problemName);
        ((DemoService)Mockito.verify((Object)this.demoService)).loadDemo(problemName);
    }

    @Test
    void clear() {
        this.webSocketController.clear();
        ((LocationService)Mockito.verify((Object)this.locationService)).clear();
    }
}

