/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.vehiclerouting.service.location;

import java.util.Arrays;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentMatchers;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.verification.VerificationMode;
import org.optaweb.vehiclerouting.domain.Coordinates;
import org.optaweb.vehiclerouting.domain.Location;
import org.optaweb.vehiclerouting.service.location.DistanceMatrix;
import org.optaweb.vehiclerouting.service.location.LocationRepository;
import org.optaweb.vehiclerouting.service.location.LocationService;
import org.optaweb.vehiclerouting.service.location.RouteOptimizer;
import org.springframework.boot.context.event.ApplicationStartedEvent;

@ExtendWith(value={MockitoExtension.class})
class LocationServiceTest {
    @Mock
    private LocationRepository repository;
    @Mock
    private RouteOptimizer optimizer;
    @Mock
    private DistanceMatrix distanceMatrix;
    @InjectMocks
    private LocationService locationService;
    @Mock
    ApplicationStartedEvent event;
    private final Coordinates coordinates = Coordinates.valueOf((double)0.0, (double)1.0);
    private final Location location = new Location(1L, this.coordinates);
    private final List<Location> persistedLocations = Arrays.asList(this.location, this.location, this.location);

    LocationServiceTest() {
    }

    @Test
    void createLocation_should_validate_arguments() {
        Assertions.assertThatNullPointerException().isThrownBy(() -> this.locationService.createLocation(null, "x"));
        Assertions.assertThatNullPointerException().isThrownBy(() -> this.locationService.createLocation(this.coordinates, null));
    }

    @Test
    void createLocation() {
        String description = "new location";
        Mockito.when((Object)this.repository.createLocation(this.coordinates, description)).thenReturn((Object)this.location);
        Assertions.assertThat((boolean)this.locationService.createLocation(this.coordinates, description)).isTrue();
        ((LocationRepository)Mockito.verify((Object)this.repository)).createLocation(this.coordinates, description);
        ((DistanceMatrix)Mockito.verify((Object)this.distanceMatrix)).addLocation(this.location);
        ((RouteOptimizer)Mockito.verify((Object)this.optimizer)).addLocation((Location)ArgumentMatchers.eq((Object)this.location), (DistanceMatrix)ArgumentMatchers.any(DistanceMatrix.class));
    }

    @Test
    void removeLocation() {
        Mockito.when((Object)this.repository.removeLocation(this.location.id())).thenReturn((Object)this.location);
        this.locationService.removeLocation(this.location.id());
        ((LocationRepository)Mockito.verify((Object)this.repository)).removeLocation(this.location.id());
        ((RouteOptimizer)Mockito.verify((Object)this.optimizer)).removeLocation(this.location);
    }

    @Test
    void clear() {
        this.locationService.clear();
        ((RouteOptimizer)Mockito.verify((Object)this.optimizer)).clear();
        ((DistanceMatrix)Mockito.verify((Object)this.distanceMatrix)).clear();
        ((LocationRepository)Mockito.verify((Object)this.repository)).removeAll();
    }

    @Test
    void should_reload_on_startup() {
        Mockito.when((Object)this.repository.locations()).thenReturn(this.persistedLocations);
        this.locationService.reload(this.event);
        ((LocationRepository)Mockito.verify((Object)this.repository)).locations();
        ((DistanceMatrix)Mockito.verify((Object)this.distanceMatrix, (VerificationMode)Mockito.times((int)this.persistedLocations.size()))).addLocation(this.location);
        ((RouteOptimizer)Mockito.verify((Object)this.optimizer, (VerificationMode)Mockito.times((int)this.persistedLocations.size()))).addLocation(this.location, this.distanceMatrix);
    }

    @Test
    void should_not_optimize_and_roll_back_if_distance_calculation_fails() {
        Mockito.when((Object)this.repository.createLocation(this.coordinates, "")).thenReturn((Object)this.location);
        ((DistanceMatrix)Mockito.doThrow(RuntimeException.class).when((Object)this.distanceMatrix)).addLocation((Location)ArgumentMatchers.any());
        Assertions.assertThat((boolean)this.locationService.createLocation(this.coordinates, "")).isFalse();
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.optimizer});
        ((LocationRepository)Mockito.verify((Object)this.repository)).removeLocation(this.location.id());
    }
}

