/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.vehiclerouting.service.route;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Captor;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.junit.jupiter.MockitoSettings;
import org.mockito.quality.Strictness;
import org.mockito.verification.VerificationMode;
import org.optaweb.vehiclerouting.domain.Coordinates;
import org.optaweb.vehiclerouting.domain.Location;
import org.optaweb.vehiclerouting.domain.RouteWithTrack;
import org.optaweb.vehiclerouting.domain.RoutingPlan;
import org.optaweb.vehiclerouting.service.location.LocationRepository;
import org.optaweb.vehiclerouting.service.route.RouteChangedEvent;
import org.optaweb.vehiclerouting.service.route.RouteListener;
import org.optaweb.vehiclerouting.service.route.RoutePublisher;
import org.optaweb.vehiclerouting.service.route.Router;
import org.optaweb.vehiclerouting.service.route.ShallowRoute;

@ExtendWith(value={MockitoExtension.class})
@MockitoSettings(strictness=Strictness.WARN)
class RouteListenerTest {
    @Mock
    private Router router;
    @Mock
    private RoutePublisher publisher;
    @Mock
    private LocationRepository locationRepository;
    @Captor
    private ArgumentCaptor<RoutingPlan> routeArgumentCaptor;
    @InjectMocks
    private RouteListener routeListener;

    RouteListenerTest() {
    }

    @Test
    void new_listener_should_return_empty_best_route() {
        RoutingPlan bestRoutingPlan = this.routeListener.getBestRoutingPlan();
        Assertions.assertThat((String)bestRoutingPlan.distance()).isEmpty();
        Assertions.assertThat((Optional)bestRoutingPlan.depot()).isEmpty();
        Assertions.assertThat((List)bestRoutingPlan.routes()).isEmpty();
    }

    @Test
    void event_with_no_routes_should_be_published_as_an_empty_routing_plan() {
        RouteChangedEvent event = new RouteChangedEvent((Object)this, "", null, Collections.emptyList());
        this.routeListener.onApplicationEvent(event);
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.router});
        ((RoutePublisher)Mockito.verify((Object)this.publisher)).publish((RoutingPlan)this.routeArgumentCaptor.capture());
        RoutingPlan routingPlan = (RoutingPlan)this.routeArgumentCaptor.getValue();
        Assertions.assertThat((Optional)routingPlan.depot()).isEmpty();
        Assertions.assertThat((List)routingPlan.routes()).isEmpty();
    }

    @Test
    void event_with_no_visits_and_a_depot_should_be_published_as_plan_with_empty_routes() {
        Coordinates depotCoordinates = Coordinates.valueOf((double)0.0, (double)0.1);
        Location depot = new Location(1L, depotCoordinates);
        ShallowRoute route = new ShallowRoute(Long.valueOf(depot.id()), Collections.emptyList());
        Mockito.when((Object)this.locationRepository.find(Long.valueOf(depot.id()))).thenReturn(Optional.of(depot));
        RouteChangedEvent event = new RouteChangedEvent((Object)this, "0 km", Long.valueOf(depot.id()), Collections.singletonList(route));
        this.routeListener.onApplicationEvent(event);
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.router});
        ((RoutePublisher)Mockito.verify((Object)this.publisher)).publish((RoutingPlan)this.routeArgumentCaptor.capture());
        RoutingPlan routingPlan = (RoutingPlan)this.routeArgumentCaptor.getValue();
        Assertions.assertThat((Optional)routingPlan.depot()).contains((Object)depot);
        Assertions.assertThat((List)routingPlan.routes()).hasSize(1);
        RouteWithTrack routeWithTrack = (RouteWithTrack)routingPlan.routes().iterator().next();
        Assertions.assertThat((Object)routeWithTrack.depot()).isEqualTo((Object)depot);
        Assertions.assertThat((List)routeWithTrack.visits()).isEmpty();
        Assertions.assertThat((List)routeWithTrack.track()).isEmpty();
    }

    @Test
    void listener_should_publish_routing_plan_when_an_update_event_occurs() {
        Coordinates depotCoordinates = Coordinates.valueOf((double)0.0, (double)0.1);
        Coordinates visitCoordinates = Coordinates.valueOf((double)2.0, (double)-0.2);
        Coordinates checkpoint1 = Coordinates.valueOf((double)12.0, (double)12.0);
        Coordinates checkpoint2 = Coordinates.valueOf((double)21.0, (double)21.0);
        List<Coordinates> path1 = Arrays.asList(depotCoordinates, checkpoint1, checkpoint2, visitCoordinates);
        List<Coordinates> path2 = Arrays.asList(visitCoordinates, checkpoint2, checkpoint1, depotCoordinates);
        Mockito.when((Object)this.router.getPath(depotCoordinates, visitCoordinates)).thenReturn(path1);
        Mockito.when((Object)this.router.getPath(visitCoordinates, depotCoordinates)).thenReturn(path2);
        Location depot = new Location(1L, depotCoordinates);
        Location visit = new Location(2L, visitCoordinates);
        String distance = "xy";
        Mockito.when((Object)this.locationRepository.find(Long.valueOf(depot.id()))).thenReturn(Optional.of(depot));
        Mockito.when((Object)this.locationRepository.find(Long.valueOf(visit.id()))).thenReturn(Optional.of(visit));
        ShallowRoute route = new ShallowRoute(Long.valueOf(depot.id()), Collections.singletonList(visit.id()));
        RouteChangedEvent event = new RouteChangedEvent((Object)this, "xy", Long.valueOf(depot.id()), Collections.singletonList(route));
        this.routeListener.onApplicationEvent(event);
        ((RoutePublisher)Mockito.verify((Object)this.publisher)).publish((RoutingPlan)this.routeArgumentCaptor.capture());
        RoutingPlan routingPlan = (RoutingPlan)this.routeArgumentCaptor.getValue();
        Assertions.assertThat((String)routingPlan.distance()).isEqualTo((Object)"xy");
        Assertions.assertThat((Optional)routingPlan.depot()).contains((Object)depot);
        Assertions.assertThat((List)routingPlan.routes()).hasSize(1);
        RouteWithTrack routeWithTrack = (RouteWithTrack)routingPlan.routes().iterator().next();
        Assertions.assertThat((Object)routeWithTrack.depot()).isEqualTo((Object)depot);
        Assertions.assertThat((List)routeWithTrack.visits()).containsExactly((Object[])new Location[]{visit});
        Assertions.assertThat((List)routeWithTrack.track()).containsExactly((Object[])new List[]{path1, path2});
        Assertions.assertThat((Object)this.routeListener.getBestRoutingPlan()).isEqualTo((Object)routingPlan);
    }

    @Test
    void should_discard_update_gracefully_if_one_of_location_has_been_removed() {
        Location depot = new Location(1L, Coordinates.valueOf((double)1.0, (double)2.0));
        Location visit = new Location(2L, Coordinates.valueOf((double)-1.0, (double)-2.0));
        Mockito.when((Object)this.locationRepository.find(Long.valueOf(depot.id()))).thenReturn(Optional.of(depot));
        Mockito.when((Object)this.locationRepository.find(Long.valueOf(visit.id()))).thenReturn(Optional.empty());
        ShallowRoute route = new ShallowRoute(Long.valueOf(depot.id()), Collections.singletonList(visit.id()));
        RouteChangedEvent event = new RouteChangedEvent((Object)this, "", Long.valueOf(depot.id()), Collections.singletonList(route));
        Assertions.assertThat((Object)this.routeListener.getBestRoutingPlan()).isEqualTo((Object)RoutingPlan.empty());
        this.routeListener.onApplicationEvent(event);
        ((Router)Mockito.verify((Object)this.router, (VerificationMode)Mockito.never())).getPath((Coordinates)ArgumentMatchers.any(), (Coordinates)ArgumentMatchers.any());
        ((RoutePublisher)Mockito.verify((Object)this.publisher, (VerificationMode)Mockito.never())).publish((RoutingPlan)ArgumentMatchers.any());
        Assertions.assertThat((Object)this.routeListener.getBestRoutingPlan()).isEqualTo((Object)RoutingPlan.empty());
    }
}

