/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.vehiclerouting.plugin.planner;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.optaplanner.examples.vehiclerouting.domain.location.RoadLocation;
import org.optaweb.vehiclerouting.domain.Location;

class DistanceMap
implements Map<RoadLocation, Double> {
    private final Location location;
    private final Map<Long, Double> distanceMap;

    DistanceMap(Location location, Map<Long, Double> distanceMap) {
        this.location = location;
        this.distanceMap = distanceMap;
    }

    @Override
    public int size() {
        return this.distanceMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.distanceMap.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.distanceMap.containsKey(((RoadLocation)key).getId());
    }

    @Override
    public boolean containsValue(Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Double get(Object key) {
        if (!this.containsKey(key)) {
            throw new IllegalArgumentException("Distance from " + this.location + " to " + key + " hasn't been recorded.\nWe only know distances to " + this.distanceMap.keySet());
        }
        return (Double)this.distanceMap.get(((RoadLocation)key).getId()) / 1000.0;
    }

    @Override
    public Double put(RoadLocation key, Double value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Double remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(Map<? extends RoadLocation, ? extends Double> m) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<RoadLocation> keySet() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Collection<Double> values() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<Map.Entry<RoadLocation, Double>> entrySet() {
        throw new UnsupportedOperationException();
    }
}

