/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.vehiclerouting.plugin.planner;

import java.time.Duration;
import org.optaplanner.core.api.solver.Solver;
import org.optaplanner.core.api.solver.SolverFactory;
import org.optaplanner.core.config.solver.termination.TerminationConfig;
import org.optaplanner.examples.vehiclerouting.domain.VehicleRoutingSolution;
import org.optaweb.vehiclerouting.plugin.planner.OptimizerProperties;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.task.AsyncTaskExecutor;
import org.springframework.core.task.SimpleAsyncTaskExecutor;

@Configuration
class RouteOptimizerConfig {
    private final OptimizerProperties optimizerProperties;

    @Autowired
    RouteOptimizerConfig(OptimizerProperties optimizerProperties) {
        this.optimizerProperties = optimizerProperties;
    }

    @Bean
    Solver<VehicleRoutingSolution> solver() {
        SolverFactory sf = SolverFactory.createFromXmlResource((String)"org/optaplanner/examples/vehiclerouting/solver/vehicleRoutingSolverConfig.xml");
        Duration timeout = this.optimizerProperties.getTimeout();
        sf.getSolverConfig().setTerminationConfig(new TerminationConfig().withSecondsSpentLimit(Long.valueOf(timeout.getSeconds())));
        sf.getSolverConfig().setDaemon(Boolean.valueOf(true));
        return sf.buildSolver();
    }

    @Bean
    AsyncTaskExecutor executor() {
        SimpleAsyncTaskExecutor executor = new SimpleAsyncTaskExecutor();
        executor.setConcurrencyLimit(1);
        return executor;
    }
}

