/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.vehiclerouting.plugin.planner;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.optaplanner.core.api.score.buildin.hardsoftlong.HardSoftLongScore;
import org.optaplanner.core.api.solver.Solver;
import org.optaplanner.core.api.solver.event.BestSolutionChangedEvent;
import org.optaplanner.core.api.solver.event.SolverEventListener;
import org.optaplanner.core.impl.solver.ProblemFactChange;
import org.optaplanner.examples.vehiclerouting.domain.Depot;
import org.optaplanner.examples.vehiclerouting.domain.VehicleRoutingSolution;
import org.optaplanner.examples.vehiclerouting.domain.location.RoadLocation;
import org.optaweb.vehiclerouting.domain.Location;
import org.optaweb.vehiclerouting.plugin.planner.DistanceMap;
import org.optaweb.vehiclerouting.plugin.planner.RouteOptimizerImpl;
import org.optaweb.vehiclerouting.plugin.planner.SolutionUtil;
import org.optaweb.vehiclerouting.plugin.planner.change.AddCustomer;
import org.optaweb.vehiclerouting.plugin.planner.change.RemoveCustomer;
import org.optaweb.vehiclerouting.plugin.planner.change.RemoveLocation;
import org.optaweb.vehiclerouting.service.location.DistanceMatrix;
import org.optaweb.vehiclerouting.service.location.RouteOptimizer;
import org.optaweb.vehiclerouting.service.route.RouteChangedEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.core.task.AsyncTaskExecutor;
import org.springframework.stereotype.Component;

@Component
class RouteOptimizerImpl
implements RouteOptimizer,
SolverEventListener<VehicleRoutingSolution> {
    private static final Logger logger = LoggerFactory.getLogger(RouteOptimizerImpl.class);
    private final ApplicationEventPublisher publisher;
    private final Solver<VehicleRoutingSolution> solver;
    private final AsyncTaskExecutor executor;
    private Future<VehicleRoutingSolution> solverFuture;
    private VehicleRoutingSolution solution;

    @Autowired
    RouteOptimizerImpl(ApplicationEventPublisher publisher, Solver<VehicleRoutingSolution> solver, AsyncTaskExecutor executor) {
        this.publisher = publisher;
        this.solver = solver;
        this.executor = executor;
        this.solver.addEventListener((SolverEventListener)this);
        this.solution = SolutionUtil.initialSolution();
    }

    private void publishRoute(VehicleRoutingSolution solution) {
        String distanceString = solution.getDistanceString(null).replaceFirst(" \\d+ms$", "");
        logger.info("New solution with {} depots, {} vehicles, {} customers, distance: {}", new Object[]{solution.getDepotList().size(), solution.getVehicleList().size(), solution.getCustomerList().size(), distanceString});
        List routes = SolutionUtil.routes((VehicleRoutingSolution)solution);
        logger.debug("Routes: {}", (Object)routes);
        this.publisher.publishEvent((ApplicationEvent)new RouteChangedEvent((Object)this, distanceString, SolutionUtil.depot((VehicleRoutingSolution)solution), (Collection)routes));
    }

    private void startSolver() {
        if (this.solverFuture != null) {
            throw new IllegalStateException("Solver start has already been requested");
        }
        this.solverFuture = this.executor.submit((Callable)((SolvingTask)() -> (VehicleRoutingSolution)this.solver.solve((Object)this.solution)));
    }

    boolean isSolving() {
        if (this.solverFuture == null) {
            return false;
        }
        this.assertSolverIsAlive();
        return true;
    }

    private void assertSolverIsAlive() {
        if (this.solverFuture.isDone()) {
            try {
                this.solverFuture.get();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException("Solver has died", e);
            }
            catch (ExecutionException e) {
                throw new RuntimeException("Solver has died", e);
            }
            throw new IllegalStateException("Solver has finished solving even though it operates in daemon mode.");
        }
    }

    void stopSolver() {
        if (this.solverFuture != null) {
            this.solver.terminateEarly();
            try {
                this.solverFuture.get();
                this.solverFuture = null;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException("Failed to stop solver", e);
            }
            catch (ExecutionException e) {
                throw new RuntimeException("Failed to stop solver", e);
            }
        }
    }

    public void bestSolutionChanged(BestSolutionChangedEvent<VehicleRoutingSolution> bestSolutionChangedEvent) {
        if (!bestSolutionChangedEvent.isEveryProblemFactChangeProcessed()) {
            logger.info("Ignoring a new best solution that has some problem facts missing");
            return;
        }
        this.solution = (VehicleRoutingSolution)bestSolutionChangedEvent.getNewBestSolution();
        this.publishRoute(this.solution);
    }

    public void addLocation(Location domainLocation, DistanceMatrix distanceMatrix) {
        block5: {
            RoadLocation location;
            block4: {
                location = SolutionUtil.planningLocation((Location)domainLocation);
                DistanceMap distanceMap = new DistanceMap(domainLocation, distanceMatrix.getRow(domainLocation));
                location.setTravelDistanceMap((Map)distanceMap);
                if (this.isSolving()) break block4;
                switch (this.solution.getLocationList().size()) {
                    case 0: {
                        Depot depot = SolutionUtil.addDepot((VehicleRoutingSolution)this.solution, (org.optaplanner.examples.vehiclerouting.domain.location.Location)location);
                        SolutionUtil.moveAllVehiclesTo((VehicleRoutingSolution)this.solution, (Depot)depot);
                        this.publishRoute(this.solution);
                        break block5;
                    }
                    case 1: {
                        SolutionUtil.addCustomer((VehicleRoutingSolution)this.solution, (org.optaplanner.examples.vehiclerouting.domain.location.Location)location, (int)1);
                        this.startSolver();
                        break block5;
                    }
                    default: {
                        throw new IllegalStateException("Illegal number of locations when solver is not solving: " + this.solution.getLocationList().size());
                    }
                }
            }
            this.solver.addProblemFactChange((ProblemFactChange)new AddCustomer((org.optaplanner.examples.vehiclerouting.domain.location.Location)location));
        }
    }

    public void removeLocation(Location domainLocation) {
        RoadLocation location = SolutionUtil.planningLocation((Location)domainLocation);
        if (!this.isSolving()) {
            if (this.solution.getLocationList().size() != 1) {
                throw new IllegalStateException("Impossible number of locations (" + this.solution.getLocationList().size() + ") when solver is not solving.\n" + this.solution.getLocationList());
            }
            this.solution.getLocationList().clear();
            this.solution.getDepotList().clear();
            SolutionUtil.moveAllVehiclesTo((VehicleRoutingSolution)this.solution, null);
            this.publishRoute(this.solution);
        } else {
            if (((Depot)this.solution.getDepotList().get(0)).getLocation().getId().equals(location.getId())) {
                throw new IllegalStateException("You can only remove depot if there are no customers.");
            }
            if (this.solution.getCustomerList().size() == 1) {
                this.stopSolver();
                this.solution.getCustomerList().clear();
                this.solution.getLocationList().removeIf(arg_0 -> RouteOptimizerImpl.lambda$removeLocation$1((org.optaplanner.examples.vehiclerouting.domain.location.Location)location, arg_0));
                this.solution.getVehicleList().forEach(vehicle -> vehicle.setNextCustomer(null));
                this.solution.setScore(HardSoftLongScore.ZERO);
                this.publishRoute(this.solution);
            } else {
                this.solver.addProblemFactChanges(Arrays.asList(new RemoveCustomer((org.optaplanner.examples.vehiclerouting.domain.location.Location)location), new RemoveLocation((org.optaplanner.examples.vehiclerouting.domain.location.Location)location)));
            }
        }
    }

    public void clear() {
        this.stopSolver();
        this.solution = SolutionUtil.initialSolution();
        this.publishRoute(this.solution);
    }

    private static /* synthetic */ boolean lambda$removeLocation$1(org.optaplanner.examples.vehiclerouting.domain.location.Location location, org.optaplanner.examples.vehiclerouting.domain.location.Location l) {
        return l.getId().equals(location.getId());
    }
}

