/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.vehiclerouting.plugin.routing;

import com.graphhopper.GHRequest;
import com.graphhopper.GHResponse;
import com.graphhopper.reader.osm.GraphHopperOSM;
import com.graphhopper.util.PointList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.optaweb.vehiclerouting.domain.Coordinates;
import org.optaweb.vehiclerouting.service.distance.DistanceCalculator;
import org.optaweb.vehiclerouting.service.route.Router;
import org.springframework.stereotype.Component;

@Component
class RouterImpl
implements Router,
DistanceCalculator {
    private final GraphHopperOSM graphHopper;

    RouterImpl(GraphHopperOSM graphHopper) {
        this.graphHopper = graphHopper;
    }

    public List<Coordinates> getPath(Coordinates from, Coordinates to) {
        GHRequest ghRequest = new GHRequest(from.latitude().doubleValue(), from.longitude().doubleValue(), to.latitude().doubleValue(), to.longitude().doubleValue());
        PointList points = this.graphHopper.route(ghRequest).getBest().getPoints();
        return StreamSupport.stream(points.spliterator(), false).map(ghPoint3D -> Coordinates.valueOf((double)ghPoint3D.lat, (double)ghPoint3D.lon)).collect(Collectors.toList());
    }

    public long travelTimeMillis(Coordinates from, Coordinates to) {
        GHRequest ghRequest = new GHRequest(from.latitude().doubleValue(), from.longitude().doubleValue(), to.latitude().doubleValue(), to.longitude().doubleValue());
        GHResponse ghResponse = this.graphHopper.route(ghRequest);
        if (ghResponse.hasErrors()) {
            throw new RuntimeException("No route", (Throwable)ghResponse.getErrors().get(0));
        }
        return ghResponse.getBest().getTime();
    }
}

