/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.vehiclerouting.service.demo.dataset;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.io.IOException;
import java.io.Reader;
import java.util.stream.Collectors;
import org.optaweb.vehiclerouting.domain.Coordinates;
import org.optaweb.vehiclerouting.domain.LocationData;
import org.optaweb.vehiclerouting.domain.RoutingProblem;
import org.optaweb.vehiclerouting.service.demo.dataset.DataSet;
import org.optaweb.vehiclerouting.service.demo.dataset.DataSetLocation;
import org.springframework.stereotype.Component;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class DataSetMarshaller {
    private final ObjectMapper mapper;

    DataSetMarshaller() {
        this.mapper = new ObjectMapper((JsonFactory)new YAMLFactory());
    }

    DataSetMarshaller(ObjectMapper mapper) {
        this.mapper = mapper;
    }

    public RoutingProblem unmarshal(Reader reader) {
        return DataSetMarshaller.toDomain((DataSet)this.unmarshalToDataSet(reader));
    }

    public String marshal(RoutingProblem routingProblem) {
        return this.marshal(DataSetMarshaller.toDataSet((RoutingProblem)routingProblem));
    }

    DataSet unmarshalToDataSet(Reader reader) {
        try {
            return (DataSet)this.mapper.readValue(reader, DataSet.class);
        }
        catch (IOException e) {
            throw new IllegalStateException("Can't read demo data set.", e);
        }
    }

    String marshal(DataSet dataSet) {
        try {
            return this.mapper.writeValueAsString((Object)dataSet);
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException("Failed to marshal data set (" + dataSet.getName() + ")", e);
        }
    }

    static DataSet toDataSet(RoutingProblem routingProblem) {
        DataSet dataSet = new DataSet();
        dataSet.setName(routingProblem.name());
        dataSet.setDepot((DataSetLocation)routingProblem.depot().map(DataSetMarshaller::toDataSet).orElse(null));
        dataSet.setVisits(routingProblem.visits().stream().map(DataSetMarshaller::toDataSet).collect(Collectors.toList()));
        return dataSet;
    }

    static DataSetLocation toDataSet(LocationData locationData) {
        return new DataSetLocation(locationData.description(), locationData.coordinates().latitude().doubleValue(), locationData.coordinates().longitude().doubleValue());
    }

    static RoutingProblem toDomain(DataSet dataSet) {
        return new RoutingProblem(dataSet.getName(), DataSetMarshaller.toDomain((DataSetLocation)dataSet.getDepot()), dataSet.getVisits().stream().map(DataSetMarshaller::toDomain).collect(Collectors.toList()));
    }

    static LocationData toDomain(DataSetLocation dataSetLocation) {
        return new LocationData(Coordinates.valueOf((double)dataSetLocation.getLatitude(), (double)dataSetLocation.getLongitude()), dataSetLocation.getLabel());
    }
}

