/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.vehiclerouting.service.route;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.optaweb.vehiclerouting.domain.Coordinates;
import org.optaweb.vehiclerouting.domain.Location;
import org.optaweb.vehiclerouting.domain.Route;
import org.optaweb.vehiclerouting.domain.RouteWithTrack;
import org.optaweb.vehiclerouting.domain.RoutingPlan;
import org.optaweb.vehiclerouting.service.location.LocationRepository;
import org.optaweb.vehiclerouting.service.route.RouteChangedEvent;
import org.optaweb.vehiclerouting.service.route.RoutePublisher;
import org.optaweb.vehiclerouting.service.route.Router;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Service;

@Service
public class RouteListener
implements ApplicationListener<RouteChangedEvent> {
    private static final Logger logger = LoggerFactory.getLogger(RouteListener.class);
    private final Router router;
    private final RoutePublisher publisher;
    private final LocationRepository locationRepository;
    private RoutingPlan bestRoutingPlan;

    RouteListener(Router router, RoutePublisher publisher, LocationRepository locationRepository) {
        this.router = router;
        this.publisher = publisher;
        this.locationRepository = locationRepository;
        this.bestRoutingPlan = RoutingPlan.empty();
    }

    public void onApplicationEvent(RouteChangedEvent event) {
        Location depot = event.depot().flatMap(arg_0 -> ((LocationRepository)this.locationRepository).find(arg_0)).orElse(null);
        try {
            List routes = event.routes().stream().map(shallowRoute -> new Route(this.findLocationById(shallowRoute.depotId), shallowRoute.visitIds.stream().map(arg_0 -> this.findLocationById(arg_0)).collect(Collectors.toList()))).map(route -> new RouteWithTrack(route, this.track(route.depot(), route.visits()))).collect(Collectors.toList());
            this.bestRoutingPlan = new RoutingPlan(event.distance(), depot, routes);
            this.publisher.publish(this.bestRoutingPlan);
        }
        catch (IllegalStateException e) {
            logger.warn("Discarding an outdated routing plan: {}", (Object)e.toString());
        }
    }

    private Location findLocationById(Long id) {
        return (Location)this.locationRepository.find(id).orElseThrow(() -> new IllegalStateException("Location {id=" + id + "} not found in the repository"));
    }

    private List<List<Coordinates>> track(Location depot, List<Location> route) {
        if (route.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Location> itinerary = new ArrayList<Location>();
        itinerary.add(depot);
        itinerary.addAll(route);
        itinerary.add(depot);
        ArrayList<List<Coordinates>> paths = new ArrayList<List<Coordinates>>();
        for (int i = 0; i < itinerary.size() - 1; ++i) {
            Location fromLocation = (Location)itinerary.get(i);
            Location toLocation = (Location)itinerary.get(i + 1);
            List path = this.router.getPath(fromLocation.coordinates(), toLocation.coordinates());
            paths.add(path);
        }
        return paths;
    }

    public RoutingPlan getBestRoutingPlan() {
        return this.bestRoutingPlan;
    }
}

