/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.vehiclerouting.domain;

import java.math.BigDecimal;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.optaweb.vehiclerouting.domain.Coordinates;
import org.optaweb.vehiclerouting.domain.Location;
import org.optaweb.vehiclerouting.domain.LocationData;

class LocationDataTest {
    LocationDataTest() {
    }

    @Test
    void constructor_params_must_not_be_null() {
        Assertions.assertThatNullPointerException().isThrownBy(() -> new LocationData(null, ""));
        Assertions.assertThatNullPointerException().isThrownBy(() -> new LocationData(Coordinates.valueOf((double)1.0, (double)1.0), null));
    }

    @Test
    void locations_are_equal_if_they_have_same_properties() {
        Coordinates coordinates0 = new Coordinates(BigDecimal.ZERO, BigDecimal.ZERO);
        Coordinates coordinates1 = new Coordinates(BigDecimal.ONE, BigDecimal.ONE);
        String description = "test description";
        LocationData locationData = new LocationData(coordinates0, description);
        Assertions.assertThat((Object)locationData).isNotEqualTo((Object)new LocationData(coordinates1, description));
        Assertions.assertThat((Object)locationData).isNotEqualTo((Object)new LocationData(coordinates0, "xyz"));
        Assertions.assertThat((Object)locationData).isNotEqualTo(null);
        Assertions.assertThat((Object)locationData).isNotEqualTo((Object)new Location(0L, coordinates0, description));
        Assertions.assertThat((Object)locationData).isEqualTo((Object)locationData);
        Assertions.assertThat((Object)locationData).isEqualTo((Object)new LocationData(coordinates0, description));
    }
}

