/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.vehiclerouting.domain;

import java.math.BigDecimal;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.optaweb.vehiclerouting.domain.Coordinates;
import org.optaweb.vehiclerouting.domain.Location;
import org.optaweb.vehiclerouting.domain.LocationData;

class LocationTest {
    LocationTest() {
    }

    @Test
    void constructor_params_must_not_be_null() {
        Assertions.assertThatNullPointerException().isThrownBy(() -> new Location(0L, null, ""));
        Assertions.assertThatNullPointerException().isThrownBy(() -> new Location(0L, Coordinates.valueOf((double)1.0, (double)1.0), null));
    }

    @Test
    void locations_are_identified_based_on_id() {
        Coordinates coordinates0 = new Coordinates(BigDecimal.ZERO, BigDecimal.ZERO);
        Coordinates coordinates1 = new Coordinates(BigDecimal.ONE, BigDecimal.ONE);
        String description = "test description";
        long id = 0L;
        Location location = new Location(0L, coordinates0, "test description");
        Assertions.assertThat((Object)location).isNotEqualTo((Object)new Location(1L, coordinates0, "test description"));
        Assertions.assertThat((Object)location).isNotEqualTo(null);
        Assertions.assertThat((Object)location).isNotEqualTo((Object)new LocationData(coordinates0, "test description"));
        Assertions.assertThat((Object)location).isEqualTo((Object)location);
        Assertions.assertThat((Object)location).isEqualTo((Object)new Location(0L, coordinates0, "test description"));
        Assertions.assertThat((Object)location).isEqualTo((Object)new Location(0L, coordinates1, "test description"));
        Assertions.assertThat((Object)location).isEqualTo((Object)new Location(0L, coordinates0, "xyz"));
    }

    @Test
    void constructor_without_description_should_create_empty_description() {
        Assertions.assertThat((String)new Location(7L, Coordinates.valueOf((double)3.14, (double)4.13)).description()).isEmpty();
    }
}

