/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.vehiclerouting.plugin.persistence;

import java.math.BigDecimal;
import java.util.List;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.optaweb.vehiclerouting.domain.Coordinates;
import org.optaweb.vehiclerouting.domain.Location;
import org.optaweb.vehiclerouting.plugin.persistence.LocationCrudRepository;
import org.optaweb.vehiclerouting.plugin.persistence.LocationEntity;
import org.optaweb.vehiclerouting.plugin.persistence.LocationRepositoryImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.autoconfigure.orm.jpa.DataJpaTest;
import org.springframework.test.context.junit.jupiter.SpringExtension;

@DataJpaTest
@ExtendWith(value={SpringExtension.class})
class LocationRepositoryIntegrationTest {
    @Autowired
    private LocationCrudRepository crudRepository;
    private LocationRepositoryImpl repository;

    LocationRepositoryIntegrationTest() {
    }

    @BeforeEach
    void setUp() {
        this.repository = new LocationRepositoryImpl(this.crudRepository);
    }

    @Test
    void db_schema() {
        BigDecimal maxLatitude = new BigDecimal("90.0000000");
        BigDecimal maxLongitude = new BigDecimal("214.7483647");
        BigDecimal minLatitude = maxLatitude.negate();
        BigDecimal minLongitude = maxLongitude.negate();
        String description = "...";
        LocationEntity minLocation = new LocationEntity(minLatitude, minLongitude, "...");
        LocationEntity maxLocation = new LocationEntity(maxLatitude, maxLongitude, "...");
        this.crudRepository.save((Object)minLocation);
        this.crudRepository.save((Object)maxLocation);
        Assertions.assertThat((Optional)this.crudRepository.findById((Object)minLocation.getId())).get().isEqualTo((Object)minLocation);
        Assertions.assertThat((Optional)this.crudRepository.findById((Object)maxLocation.getId())).get().isEqualTo((Object)maxLocation);
    }

    @Test
    void remove_created_location() {
        Coordinates coordinates = Coordinates.valueOf((double)0.00213, (double)32.777);
        Assertions.assertThat((long)this.crudRepository.count()).isZero();
        Location location = this.repository.createLocation(coordinates, "");
        Assertions.assertThat((Object)location.coordinates()).isEqualTo((Object)coordinates);
        Assertions.assertThat((long)this.crudRepository.count()).isOne();
        Location removed = this.repository.removeLocation(location.id());
        Assertions.assertThat((Object)removed).isEqualTo((Object)location);
        Assertions.assertThatIllegalArgumentException().isThrownBy(() -> this.repository.removeLocation(location.id()));
        int uniqueNonexistentId = 7173;
        Assertions.assertThatIllegalArgumentException().isThrownBy(() -> this.repository.removeLocation((long)uniqueNonexistentId)).withMessageContaining(String.valueOf(uniqueNonexistentId));
    }

    @Test
    void get_and_remove_all_locations() {
        int locationCount = 8;
        for (int i = 0; i < locationCount; ++i) {
            this.repository.createLocation(Coordinates.valueOf((double)1.0, (double)((double)i / 100.0)), "");
        }
        Assertions.assertThat((long)this.crudRepository.count()).isEqualTo((long)locationCount);
        Assertions.assertThat((boolean)this.crudRepository.existsById((Object)locationCount)).isTrue();
        LocationEntity testEntity = (LocationEntity)this.crudRepository.findById((Object)locationCount).orElseThrow(IllegalStateException::new);
        Location testLocation = new Location(testEntity.getId(), new Coordinates(testEntity.getLatitude(), testEntity.getLongitude()));
        ((ListAssert)Assertions.assertThat((List)this.repository.locations()).hasSize(locationCount)).contains((Object[])new Location[]{testLocation});
        this.repository.removeAll();
        Assertions.assertThat((long)this.crudRepository.count()).isZero();
    }
}

