/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.vehiclerouting.plugin.planner;

import java.util.Collections;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.optaplanner.examples.vehiclerouting.domain.Customer;
import org.optaplanner.examples.vehiclerouting.domain.Depot;
import org.optaplanner.examples.vehiclerouting.domain.Vehicle;
import org.optaplanner.examples.vehiclerouting.domain.VehicleRoutingSolution;
import org.optaplanner.examples.vehiclerouting.domain.location.Location;
import org.optaplanner.examples.vehiclerouting.domain.location.RoadLocation;
import org.optaweb.vehiclerouting.plugin.planner.CustomerFactory;
import org.optaweb.vehiclerouting.plugin.planner.SolutionFactory;

class SolutionFactoryTest {
    SolutionFactoryTest() {
    }

    @Test
    void empty_solution_should_be_empty() {
        VehicleRoutingSolution solution = SolutionFactory.emptySolution();
        Assertions.assertThat((List)solution.getLocationList()).isEmpty();
        Assertions.assertThat((List)solution.getCustomerList()).isEmpty();
        Assertions.assertThat((List)solution.getDepotList()).isEmpty();
        Assertions.assertThat((List)solution.getVehicleList()).isEmpty();
        Assertions.assertThat((String)solution.getDistanceUnitOfMeasurement()).isEqualTo((Object)"sec");
    }

    @Test
    void solution_created_from_vehicles_depot_and_visits_should_be_consistent() {
        Vehicle vehicle = new Vehicle();
        RoadLocation depotLocation = new RoadLocation(1L, 1.0, 1.0);
        Depot depot = new Depot();
        depot.setLocation((Location)depotLocation);
        Customer customer = CustomerFactory.customer((Location)new RoadLocation(2L, 2.0, 2.0));
        VehicleRoutingSolution solutionWithDepot = SolutionFactory.solutionFromCustomers(Collections.singletonList(vehicle), (Depot)depot, Collections.singletonList(customer));
        Assertions.assertThat((List)solutionWithDepot.getVehicleList()).containsExactly((Object[])new Vehicle[]{vehicle});
        Assertions.assertThat((Comparable)vehicle.getDepot()).isEqualTo((Object)depot);
        Assertions.assertThat((List)solutionWithDepot.getDepotList()).containsExactly((Object[])new Depot[]{depot});
        Assertions.assertThat((List)solutionWithDepot.getCustomerList()).hasSize(1);
        Assertions.assertThat((List)solutionWithDepot.getCustomerList()).containsExactly((Object[])new Customer[]{customer});
        Assertions.assertThat((Comparable)((Customer)solutionWithDepot.getCustomerList().get(0)).getLocation()).isEqualTo((Object)customer.getLocation());
        Assertions.assertThat((List)solutionWithDepot.getLocationList()).containsExactlyInAnyOrder((Object[])new Location[]{depotLocation, customer.getLocation()});
        VehicleRoutingSolution solutionWithNoDepot = SolutionFactory.solutionFromCustomers(Collections.singletonList(vehicle), null, Collections.emptyList());
        Assertions.assertThat((List)solutionWithNoDepot.getDepotList()).isEmpty();
    }
}

