/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.vehiclerouting.plugin.planner;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.LongStream;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.optaplanner.examples.vehiclerouting.domain.Customer;
import org.optaplanner.examples.vehiclerouting.domain.Depot;
import org.optaplanner.examples.vehiclerouting.domain.Standstill;
import org.optaplanner.examples.vehiclerouting.domain.Vehicle;
import org.optaplanner.examples.vehiclerouting.domain.VehicleRoutingSolution;
import org.optaplanner.examples.vehiclerouting.domain.location.Location;
import org.optaplanner.examples.vehiclerouting.domain.location.RoadLocation;
import org.optaweb.vehiclerouting.plugin.planner.CustomerFactory;
import org.optaweb.vehiclerouting.plugin.planner.DepotFactory;
import org.optaweb.vehiclerouting.plugin.planner.SolutionFactory;
import org.optaweb.vehiclerouting.plugin.planner.SolutionPublisher;
import org.optaweb.vehiclerouting.plugin.planner.VehicleFactory;
import org.optaweb.vehiclerouting.service.route.RouteChangedEvent;
import org.optaweb.vehiclerouting.service.route.ShallowRoute;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;

@ExtendWith(value={MockitoExtension.class})
class SolutionPublisherTest {
    @Mock
    private ApplicationEventPublisher publisher;
    @InjectMocks
    private SolutionPublisher solutionPublisher;

    SolutionPublisherTest() {
    }

    @Test
    void should_covert_solution_to_event_and_publish_it() {
        this.solutionPublisher.publishSolution(SolutionFactory.emptySolution());
        ((ApplicationEventPublisher)Mockito.verify((Object)this.publisher)).publishEvent((ApplicationEvent)Mockito.any(RouteChangedEvent.class));
    }

    @Test
    void empty_solution_should_have_zero_routes_vehicles_etc() {
        VehicleRoutingSolution solution = SolutionFactory.emptySolution();
        RouteChangedEvent event = SolutionPublisher.solutionToEvent((VehicleRoutingSolution)solution, (Object)this);
        Assertions.assertThat((List)event.vehicleIds()).isEmpty();
        Assertions.assertThat((Optional)event.depotId()).isEmpty();
        Assertions.assertThat((List)event.visitIds()).isEmpty();
        Assertions.assertThat((Iterable)event.routes()).isEmpty();
        Assertions.assertThat((String)event.distance()).isEqualTo((Object)"0h 0m 0s");
    }

    @Test
    void solution_with_vehicles_and_no_depot_should_have_zero_routes() {
        long vehicleId = 1L;
        Vehicle vehicle = VehicleFactory.vehicle((long)vehicleId);
        VehicleRoutingSolution solution = SolutionFactory.solutionFromCustomers(Collections.singletonList(vehicle), null, Collections.emptyList());
        RouteChangedEvent event = SolutionPublisher.solutionToEvent((VehicleRoutingSolution)solution, (Object)this);
        Assertions.assertThat((List)event.vehicleIds()).containsExactly((Object[])new Long[]{vehicleId});
        Assertions.assertThat((Optional)event.depotId()).isEmpty();
        Assertions.assertThat((List)event.visitIds()).isEmpty();
        Assertions.assertThat((Iterable)event.routes()).isEmpty();
        Assertions.assertThat((String)event.distance()).isEqualTo((Object)"0h 0m 0s");
    }

    @Test
    void nonempty_solution_without_vehicles_should_have_zero_routes_but_contain_visits() {
        long depotId = 1L;
        long visitId = 2L;
        VehicleRoutingSolution solution = SolutionFactory.solutionFromLocations(Collections.emptyList(), (Depot)DepotFactory.depot((Location)new RoadLocation(depotId, 1.0, 1.0)), Collections.singletonList(new RoadLocation(visitId, 2.0, 2.0)));
        RouteChangedEvent event = SolutionPublisher.solutionToEvent((VehicleRoutingSolution)solution, (Object)this);
        Assertions.assertThat((List)event.vehicleIds()).isEmpty();
        Assertions.assertThat((Optional)event.depotId()).contains((Object)depotId);
        Assertions.assertThat((List)event.visitIds()).containsExactly((Object[])new Long[]{visitId});
        Assertions.assertThat((Iterable)event.routes()).isEmpty();
        Assertions.assertThat((String)event.distance()).isEqualTo((Object)"0h 0m 0s");
    }

    @Test
    void initialized_solution_should_have_one_route_per_vehicle() {
        long vehicleId1 = 1001L;
        long vehicleId2 = 2001L;
        Vehicle vehicle1 = VehicleFactory.vehicle((long)vehicleId1);
        Vehicle vehicle2 = VehicleFactory.vehicle((long)vehicleId2);
        long depotId = 1L;
        long visitId1 = 2L;
        long visitId2 = 3L;
        Depot depot = DepotFactory.depot((Location)new RoadLocation(depotId, 1.0, 1.0));
        Customer customer1 = CustomerFactory.customer((Location)new RoadLocation(visitId1, 2.0, 2.0));
        Customer customer2 = CustomerFactory.customer((Location)new RoadLocation(visitId2, 0.2, 0.2));
        VehicleRoutingSolution solution = SolutionFactory.solutionFromCustomers(Arrays.asList(vehicle1, vehicle2), (Depot)depot, Arrays.asList(customer1, customer2));
        for (Vehicle vehicle : solution.getVehicleList()) {
            vehicle.setNextCustomer(customer1);
            customer1.setPreviousStandstill((Standstill)vehicle);
        }
        customer1.setNextCustomer(customer2);
        customer2.setPreviousStandstill((Standstill)customer1);
        RouteChangedEvent event = SolutionPublisher.solutionToEvent((VehicleRoutingSolution)solution, (Object)this);
        Assertions.assertThat((Iterable)event.routes()).hasSameSizeAs((Iterable)solution.getVehicleList());
        Assertions.assertThat((LongStream)event.routes().stream().mapToLong(value -> value.vehicleId)).containsExactlyInAnyOrder((Object[])new Long[]{vehicleId1, vehicleId2});
        for (ShallowRoute route : event.routes()) {
            Assertions.assertThat((Long)route.depotId).isEqualTo((Object)depot.getId());
            Assertions.assertThat((List)route.visitIds).containsExactly((Object[])new Long[]{visitId1, visitId2});
        }
        Assertions.assertThat((List)event.vehicleIds()).containsExactlyInAnyOrder((Object[])new Long[]{vehicleId1, vehicleId2});
        Assertions.assertThat((Optional)event.depotId()).contains((Object)depotId);
        Assertions.assertThat((List)event.visitIds()).containsExactlyInAnyOrder((Object[])new Long[]{visitId1, visitId2});
        Assertions.assertThat((String)event.distance()).isEqualTo((Object)"0h 0m 0s");
    }

    @Test
    void fail_fast_if_vehicles_next_customer_doesnt_exist() {
        Vehicle vehicle = VehicleFactory.vehicle((long)1L);
        vehicle.setNextCustomer(CustomerFactory.customer((Location)new RoadLocation(2L, 2.0, 2.0)));
        VehicleRoutingSolution solution = SolutionFactory.solutionFromLocations(Collections.singletonList(vehicle), (Depot)DepotFactory.depot((Location)new RoadLocation(1L, 1.0, 1.0)), Collections.singletonList(new RoadLocation(3L, 3.0, 3.0)));
        Assertions.assertThatIllegalArgumentException().isThrownBy(() -> SolutionPublisher.solutionToEvent((VehicleRoutingSolution)solution, (Object)this)).withMessageContaining("Customer");
    }

    @Test
    void vehicle_without_a_depot_is_illegal_if_depot_exists() {
        Depot depot = DepotFactory.depot((Location)new RoadLocation(1L, 1.0, 1.0));
        Vehicle vehicle = VehicleFactory.vehicle((long)1L);
        VehicleRoutingSolution solution = SolutionFactory.solutionFromCustomers(Collections.singletonList(vehicle), (Depot)depot, Collections.emptyList());
        vehicle.setDepot(null);
        Assertions.assertThatIllegalArgumentException().isThrownBy(() -> SolutionPublisher.solutionToEvent((VehicleRoutingSolution)solution, (Object)this)).withMessageContaining("Vehicle");
    }
}

