/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.vehiclerouting.plugin.planner;

import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ThrowableAssert;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentMatchers;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.optaplanner.core.api.solver.Solver;
import org.optaplanner.examples.vehiclerouting.domain.Vehicle;
import org.optaplanner.examples.vehiclerouting.domain.VehicleRoutingSolution;
import org.optaplanner.examples.vehiclerouting.domain.location.Location;
import org.optaplanner.examples.vehiclerouting.domain.location.RoadLocation;
import org.optaweb.vehiclerouting.plugin.planner.SolverManager;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.core.task.AsyncTaskExecutor;

@ExtendWith(value={MockitoExtension.class})
class SolverExceptionTest {
    @Mock
    private Solver<VehicleRoutingSolution> solver;
    @Mock
    private AsyncTaskExecutor executor;
    @Mock
    private ApplicationEventPublisher eventPublisher;
    @InjectMocks
    private SolverManager solverManager;

    SolverExceptionTest() {
    }

    @Test
    void should_propagate_any_exception_from_solver() {
        FutureTask<Object> task = new FutureTask<Object>(() -> {
            throw new TestException();
        }, null);
        Mockito.when((Object)this.executor.submit((Callable)ArgumentMatchers.any(SolverManager.SolvingTask.class))).thenReturn(task);
        task.run();
        this.solverManager.startSolver((VehicleRoutingSolution)Mockito.mock(VehicleRoutingSolution.class));
        SolverExceptionTest.assertTestExceptionThrownDuringOperation(() -> this.solverManager.addLocation((Location)Mockito.mock(RoadLocation.class)));
        SolverExceptionTest.assertTestExceptionThrownDuringOperation(() -> this.solverManager.removeLocation((Location)Mockito.mock(RoadLocation.class)));
        SolverExceptionTest.assertTestExceptionThrownDuringOperation(() -> this.solverManager.addVehicle((Vehicle)Mockito.mock(Vehicle.class)));
        SolverExceptionTest.assertTestExceptionThrownDuringOperation(() -> this.solverManager.removeVehicle((Vehicle)Mockito.mock(Vehicle.class)));
        SolverExceptionTest.assertTestExceptionThrownWhenStoppingSolver(this.solverManager);
    }

    private static void assertTestExceptionThrownDuringOperation(ThrowableAssert.ThrowingCallable runnable) {
        SolverExceptionTest.assertTestExceptionThrownDuring(runnable, "died");
    }

    private static void assertTestExceptionThrownWhenStoppingSolver(SolverManager routeOptimizer) {
        SolverExceptionTest.assertTestExceptionThrownDuring(() -> ((SolverManager)routeOptimizer).stopSolver(), "stop");
    }

    private static void assertTestExceptionThrownDuring(ThrowableAssert.ThrowingCallable runnable, String message) {
        Assertions.assertThatExceptionOfType(RuntimeException.class).isThrownBy(runnable).withMessageContaining(message).withCauseInstanceOf(TestException.class);
    }

    private static class TestException
    extends RuntimeException {
        private TestException() {
        }
    }
}

