/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.vehiclerouting.plugin.planner.change;

import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.optaplanner.core.impl.score.director.ScoreDirector;
import org.optaplanner.examples.vehiclerouting.domain.Customer;
import org.optaplanner.examples.vehiclerouting.domain.VehicleRoutingSolution;
import org.optaplanner.examples.vehiclerouting.domain.location.Location;
import org.optaplanner.examples.vehiclerouting.domain.location.RoadLocation;
import org.optaweb.vehiclerouting.plugin.planner.CustomerFactory;
import org.optaweb.vehiclerouting.plugin.planner.SolutionFactory;
import org.optaweb.vehiclerouting.plugin.planner.change.AddCustomer;

@ExtendWith(value={MockitoExtension.class})
class AddCustomerTest {
    @Mock
    private ScoreDirector<VehicleRoutingSolution> scoreDirector;

    AddCustomerTest() {
    }

    @Test
    void add_customer_should_add_location_and_create_customer() {
        VehicleRoutingSolution solution = SolutionFactory.emptySolution();
        Mockito.when((Object)this.scoreDirector.getWorkingSolution()).thenReturn((Object)solution);
        RoadLocation location = new RoadLocation(1L, 1.0, 2.0);
        Customer customer = CustomerFactory.customer((Location)location);
        AddCustomer addCustomer = new AddCustomer(customer);
        addCustomer.doChange(this.scoreDirector);
        ((ScoreDirector)Mockito.verify(this.scoreDirector)).beforeProblemFactAdded((Object)location);
        ((ScoreDirector)Mockito.verify(this.scoreDirector)).afterProblemFactAdded((Object)location);
        Assertions.assertThat((List)solution.getLocationList()).containsExactly((Object[])new Location[]{location});
        ((ScoreDirector)Mockito.verify(this.scoreDirector)).beforeEntityAdded((Object)customer);
        ((ScoreDirector)Mockito.verify(this.scoreDirector)).afterEntityAdded((Object)customer);
        Assertions.assertThat((List)solution.getCustomerList()).containsExactly((Object[])new Customer[]{customer});
        ((ScoreDirector)Mockito.verify(this.scoreDirector)).triggerVariableListeners();
    }
}

