/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.vehiclerouting.plugin.planner.change;

import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.optaplanner.core.impl.score.director.ScoreDirector;
import org.optaplanner.examples.vehiclerouting.domain.Depot;
import org.optaplanner.examples.vehiclerouting.domain.Vehicle;
import org.optaplanner.examples.vehiclerouting.domain.VehicleRoutingSolution;
import org.optaplanner.examples.vehiclerouting.domain.location.Location;
import org.optaplanner.examples.vehiclerouting.domain.location.RoadLocation;
import org.optaweb.vehiclerouting.plugin.planner.change.ChangeVehicleCapacity;

@ExtendWith(value={MockitoExtension.class})
class ChangeVehicleCapacityTest {
    @Mock
    private ScoreDirector<VehicleRoutingSolution> scoreDirector;

    ChangeVehicleCapacityTest() {
    }

    @Test
    void change_vehicle_capacity() {
        RoadLocation location = new RoadLocation(1L, 2.0, 3.0);
        Depot depot = new Depot();
        depot.setLocation((Location)location);
        int oldCapacity = 100;
        int newCapacity = 50;
        Vehicle workingVehicle = new Vehicle();
        workingVehicle.setId(Long.valueOf(1L));
        workingVehicle.setDepot(depot);
        workingVehicle.setCapacity(oldCapacity);
        Vehicle changeVehicle = new Vehicle();
        changeVehicle.setId(Long.valueOf(1L));
        changeVehicle.setDepot(depot);
        changeVehicle.setCapacity(newCapacity);
        Mockito.when((Object)this.scoreDirector.lookUpWorkingObject((Object)changeVehicle)).thenReturn((Object)workingVehicle);
        ChangeVehicleCapacity changeVehicleCapacity = new ChangeVehicleCapacity(changeVehicle);
        changeVehicleCapacity.doChange(this.scoreDirector);
        Assertions.assertThat((int)workingVehicle.getCapacity()).isEqualTo(newCapacity);
        ((ScoreDirector)Mockito.verify(this.scoreDirector)).beforeProblemPropertyChanged((Object)workingVehicle);
        ((ScoreDirector)Mockito.verify(this.scoreDirector)).afterProblemPropertyChanged((Object)workingVehicle);
        ((ScoreDirector)Mockito.verify(this.scoreDirector)).triggerVariableListeners();
    }

    @Test
    void fail_fast_if_working_object_is_null() {
        Depot depot = new Depot();
        depot.setLocation((Location)new RoadLocation(4L, 1.0, 2.0));
        Vehicle vehicle = new Vehicle();
        vehicle.setId(Long.valueOf(1L));
        vehicle.setDepot(depot);
        Assertions.assertThatIllegalStateException().isThrownBy(() -> new ChangeVehicleCapacity(vehicle).doChange(this.scoreDirector)).withMessageContaining("working copy of");
    }
}

