/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.vehiclerouting.plugin.planner.change;

import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.optaplanner.core.impl.score.director.ScoreDirector;
import org.optaplanner.examples.vehiclerouting.domain.VehicleRoutingSolution;
import org.optaplanner.examples.vehiclerouting.domain.location.Location;
import org.optaplanner.examples.vehiclerouting.domain.location.RoadLocation;
import org.optaweb.vehiclerouting.plugin.planner.SolutionFactory;
import org.optaweb.vehiclerouting.plugin.planner.change.RemoveLocation;

@ExtendWith(value={MockitoExtension.class})
class RemoveLocationTest {
    @Mock
    private ScoreDirector<VehicleRoutingSolution> scoreDirector;

    RemoveLocationTest() {
    }

    @Test
    void remove_location() {
        VehicleRoutingSolution solution = SolutionFactory.emptySolution();
        Mockito.when((Object)this.scoreDirector.getWorkingSolution()).thenReturn((Object)solution);
        RoadLocation location = new RoadLocation(1L, 2.0, 3.0);
        solution.getLocationList().add(location);
        Mockito.when((Object)this.scoreDirector.lookUpWorkingObject((Object)location)).thenReturn((Object)location);
        RemoveLocation removeLocation = new RemoveLocation((Location)location);
        removeLocation.doChange(this.scoreDirector);
        ((ScoreDirector)Mockito.verify(this.scoreDirector)).beforeProblemFactRemoved((Object)location);
        ((ScoreDirector)Mockito.verify(this.scoreDirector)).afterProblemFactRemoved((Object)location);
        Assertions.assertThat((List)solution.getLocationList()).isEmpty();
        ((ScoreDirector)Mockito.verify(this.scoreDirector)).triggerVariableListeners();
    }

    @Test
    void fail_fast_if_working_solution_location_list_does_not_contain_working_location() {
        VehicleRoutingSolution solution = SolutionFactory.emptySolution();
        long removedId = 111L;
        RoadLocation removedLocation = new RoadLocation(removedId, 0.0, 1.0);
        removedLocation.setId(Long.valueOf(removedId));
        long wrongId = 222L;
        RoadLocation wrongLocation = new RoadLocation(wrongId, 1.0, 0.0);
        wrongLocation.setId(Long.valueOf(wrongId));
        solution.getLocationList().add(wrongLocation);
        Mockito.when((Object)this.scoreDirector.getWorkingSolution()).thenReturn((Object)solution);
        Mockito.when((Object)this.scoreDirector.lookUpWorkingObject((Object)removedLocation)).thenReturn((Object)removedLocation);
        RemoveLocation removeLocation = new RemoveLocation((Location)removedLocation);
        Assertions.assertThatIllegalStateException().isThrownBy(() -> removeLocation.doChange(this.scoreDirector)).withMessageMatching(".*List .*" + wrongId + ".* doesn't contain the working.*" + removedId + ".*");
    }

    @Test
    void fail_fast_if_working_object_is_null() {
        Mockito.when((Object)this.scoreDirector.getWorkingSolution()).thenReturn((Object)SolutionFactory.emptySolution());
        Assertions.assertThatIllegalStateException().isThrownBy(() -> new RemoveLocation((Location)new RoadLocation(1L, 2.0, 3.0)).doChange(this.scoreDirector)).withMessageContaining("working copy of");
    }
}

