/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.vehiclerouting.plugin.planner.change;

import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.optaplanner.core.impl.score.director.ScoreDirector;
import org.optaplanner.examples.vehiclerouting.domain.Customer;
import org.optaplanner.examples.vehiclerouting.domain.Depot;
import org.optaplanner.examples.vehiclerouting.domain.Standstill;
import org.optaplanner.examples.vehiclerouting.domain.Vehicle;
import org.optaplanner.examples.vehiclerouting.domain.VehicleRoutingSolution;
import org.optaplanner.examples.vehiclerouting.domain.location.Location;
import org.optaplanner.examples.vehiclerouting.domain.location.RoadLocation;
import org.optaweb.vehiclerouting.plugin.planner.SolutionFactory;
import org.optaweb.vehiclerouting.plugin.planner.change.RemoveVehicle;

@ExtendWith(value={MockitoExtension.class})
class RemoveVehicleTest {
    @Mock
    private ScoreDirector<VehicleRoutingSolution> scoreDirector;

    RemoveVehicleTest() {
    }

    @Test
    void remove_vehicle() {
        VehicleRoutingSolution solution = SolutionFactory.emptySolution();
        Mockito.when((Object)this.scoreDirector.getWorkingSolution()).thenReturn((Object)solution);
        RoadLocation location = new RoadLocation(1L, 2.0, 3.0);
        Depot depot = new Depot();
        depot.setLocation((Location)location);
        Vehicle removedVehicle = new Vehicle();
        removedVehicle.setId(Long.valueOf(1L));
        removedVehicle.setDepot(depot);
        Vehicle otherVehicle = new Vehicle();
        otherVehicle.setId(Long.valueOf(2L));
        otherVehicle.setDepot(depot);
        solution.getVehicleList().add(removedVehicle);
        solution.getVehicleList().add(otherVehicle);
        Mockito.when((Object)this.scoreDirector.lookUpWorkingObject((Object)removedVehicle)).thenReturn((Object)removedVehicle);
        Customer firstCustomer = RemoveVehicleTest.customer(1L);
        Customer lastCustomer = RemoveVehicleTest.customer(2L);
        solution.getCustomerList().add(firstCustomer);
        solution.getCustomerList().add(lastCustomer);
        removedVehicle.setNextCustomer(firstCustomer);
        firstCustomer.setPreviousStandstill((Standstill)removedVehicle);
        firstCustomer.setVehicle(removedVehicle);
        firstCustomer.setNextCustomer(lastCustomer);
        lastCustomer.setPreviousStandstill((Standstill)firstCustomer);
        lastCustomer.setVehicle(removedVehicle);
        RemoveVehicle removeVehicle = new RemoveVehicle(removedVehicle);
        removeVehicle.doChange(this.scoreDirector);
        Assertions.assertThat((Object)firstCustomer.getPreviousStandstill()).isNull();
        Assertions.assertThat((Object)lastCustomer.getPreviousStandstill()).isNull();
        Assertions.assertThat((List)solution.getVehicleList()).containsExactly((Object[])new Vehicle[]{otherVehicle});
        ((ScoreDirector)Mockito.verify(this.scoreDirector)).beforeVariableChanged((Object)firstCustomer, "previousStandstill");
        ((ScoreDirector)Mockito.verify(this.scoreDirector)).afterVariableChanged((Object)firstCustomer, "previousStandstill");
        ((ScoreDirector)Mockito.verify(this.scoreDirector)).beforeVariableChanged((Object)lastCustomer, "previousStandstill");
        ((ScoreDirector)Mockito.verify(this.scoreDirector)).afterVariableChanged((Object)lastCustomer, "previousStandstill");
        ((ScoreDirector)Mockito.verify(this.scoreDirector)).beforeProblemFactRemoved(ArgumentMatchers.any(Vehicle.class));
        ((ScoreDirector)Mockito.verify(this.scoreDirector)).afterProblemFactRemoved(ArgumentMatchers.any(Vehicle.class));
        ((ScoreDirector)Mockito.verify(this.scoreDirector)).triggerVariableListeners();
    }

    @Test
    void fail_fast_if_working_solution_vehicle_list_does_not_contain_working_vehicle() {
        VehicleRoutingSolution solution = SolutionFactory.emptySolution();
        RoadLocation location = new RoadLocation(1L, 2.0, 3.0);
        Depot depot = new Depot();
        depot.setLocation((Location)location);
        long removedId = 111L;
        Vehicle removedVehicle = new Vehicle();
        removedVehicle.setId(Long.valueOf(removedId));
        removedVehicle.setDepot(depot);
        long wrongId = 222L;
        Vehicle wrongVehicle = new Vehicle();
        wrongVehicle.setId(Long.valueOf(wrongId));
        wrongVehicle.setDepot(depot);
        solution.getVehicleList().add(wrongVehicle);
        Mockito.when((Object)this.scoreDirector.getWorkingSolution()).thenReturn((Object)solution);
        Mockito.when((Object)this.scoreDirector.lookUpWorkingObject((Object)removedVehicle)).thenReturn((Object)removedVehicle);
        RemoveVehicle removeVehicle = new RemoveVehicle(removedVehicle);
        Assertions.assertThatIllegalStateException().isThrownBy(() -> removeVehicle.doChange(this.scoreDirector)).withMessageMatching(".*List .*" + wrongId + ".* doesn't contain the working.*" + removedId + ".*");
    }

    @Test
    void fail_fast_if_working_object_is_null() {
        Mockito.when((Object)this.scoreDirector.getWorkingSolution()).thenReturn((Object)SolutionFactory.emptySolution());
        Depot depot = new Depot();
        depot.setLocation((Location)new RoadLocation(4L, 1.0, 2.0));
        Vehicle vehicle = new Vehicle();
        vehicle.setId(Long.valueOf(1L));
        vehicle.setDepot(depot);
        Assertions.assertThatIllegalStateException().isThrownBy(() -> new RemoveVehicle(vehicle).doChange(this.scoreDirector)).withMessageContaining("working copy of");
    }

    private static Customer customer(long id) {
        RoadLocation location = new RoadLocation(1000000L + id, (double)id, (double)id);
        Customer customer = new Customer();
        customer.setId(Long.valueOf(id));
        customer.setLocation((Location)location);
        return customer;
    }
}

