/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.vehiclerouting.plugin.routing;

import com.graphhopper.GHRequest;
import com.graphhopper.GHResponse;
import com.graphhopper.PathWrapper;
import com.graphhopper.reader.osm.GraphHopperOSM;
import com.graphhopper.util.PointList;
import java.util.Collections;
import java.util.List;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.junit.jupiter.MockitoSettings;
import org.mockito.quality.Strictness;
import org.optaweb.vehiclerouting.domain.Coordinates;
import org.optaweb.vehiclerouting.plugin.routing.RouterImpl;

@ExtendWith(value={MockitoExtension.class})
@MockitoSettings(strictness=Strictness.WARN)
class RouterImplTest {
    private final PointList pointList = new PointList();
    private final Coordinates from = Coordinates.valueOf((double)-4.9E-324, (double)Double.MIN_VALUE);
    private final Coordinates to = Coordinates.valueOf((double)Double.MAX_VALUE, (double)-1.7976931348623157E308);
    @Mock
    private GraphHopperOSM graphHopper;
    @Mock
    private GHResponse ghResponse;
    @Mock
    private PathWrapper pathWrapper;

    RouterImplTest() {
    }

    @BeforeEach
    void setUp() {
        Mockito.when((Object)this.graphHopper.route((GHRequest)ArgumentMatchers.any(GHRequest.class))).thenReturn((Object)this.ghResponse);
        Mockito.when((Object)this.ghResponse.getBest()).thenReturn((Object)this.pathWrapper);
        Mockito.when((Object)this.pathWrapper.getPoints()).thenReturn((Object)this.pointList);
    }

    @Test
    void travel_time_should_return_graphhopper_time() {
        RouterImpl routing = new RouterImpl(this.graphHopper);
        long travelTimeMillis = 486000000L;
        Mockito.when((Object)this.pathWrapper.getTime()).thenReturn((Object)travelTimeMillis);
        Assertions.assertThat((long)routing.travelTimeMillis(this.from, this.to)).isEqualTo(travelTimeMillis);
    }

    @Test
    void getDistance_should_throw_exception_when_no_route_exists() {
        RouterImpl routing = new RouterImpl(this.graphHopper);
        Mockito.when((Object)this.ghResponse.hasErrors()).thenReturn((Object)true);
        Mockito.when((Object)this.ghResponse.getErrors()).thenReturn(Collections.singletonList(new RuntimeException()));
        ((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> routing.travelTimeMillis(this.from, this.to)).isNotInstanceOf(NullPointerException.class)).isInstanceOf(RuntimeException.class)).hasMessageContaining("No route");
    }

    @Test
    void getRoute_should_return_graphhopper_route() {
        RouterImpl routing = new RouterImpl(this.graphHopper);
        Coordinates coordinates1 = Coordinates.valueOf((double)1.0, (double)1.0);
        Coordinates coordinates2 = Coordinates.valueOf((double)Math.E, (double)Math.PI);
        Coordinates coordinates3 = Coordinates.valueOf((double)0.1, (double)0.3333333333333333);
        this.pointList.add(coordinates1.latitude().doubleValue(), coordinates1.longitude().doubleValue());
        this.pointList.add(coordinates2.latitude().doubleValue(), coordinates2.longitude().doubleValue());
        this.pointList.add(coordinates3.latitude().doubleValue(), coordinates3.longitude().doubleValue());
        List route = routing.getPath(this.from, this.to);
        Assertions.assertThat((List)route).containsExactly((Object[])new Coordinates[]{coordinates1, coordinates2, coordinates3});
    }
}

