/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.vehiclerouting.service.region;

import com.graphhopper.reader.osm.GraphHopperOSM;
import com.graphhopper.storage.GraphHopperStorage;
import com.graphhopper.util.shapes.BBox;
import java.util.Arrays;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.optaweb.vehiclerouting.domain.Coordinates;
import org.optaweb.vehiclerouting.service.region.BoundingBox;
import org.optaweb.vehiclerouting.service.region.RegionProperties;
import org.optaweb.vehiclerouting.service.region.RegionService;

@ExtendWith(value={MockitoExtension.class})
class RegionServiceTest {
    @Mock
    private RegionProperties regionProperties;
    @Mock
    private GraphHopperOSM graphHopper;
    @InjectMocks
    private RegionService regionService;
    @Mock
    private GraphHopperStorage graphHopperStorage;

    RegionServiceTest() {
    }

    @Test
    void should_return_country_codes_from_properties() {
        List<String> countryCodes = Arrays.asList("XY", "WZ");
        Mockito.when((Object)this.regionProperties.getCountryCodes()).thenReturn(countryCodes);
        Assertions.assertThat((List)this.regionService.countryCodes()).isEqualTo(countryCodes);
    }

    @Test
    void should_return_graphHopper_bounds() {
        Mockito.when((Object)this.graphHopper.getGraphHopperStorage()).thenReturn((Object)this.graphHopperStorage);
        double minLat_Y = -90.0;
        double minLon_X = -180.0;
        double maxLat_Y = 90.0;
        double maxLon_X = 180.0;
        BBox bbox = new BBox(minLon_X, maxLon_X, minLat_Y, maxLat_Y);
        Mockito.when((Object)this.graphHopperStorage.getBounds()).thenReturn((Object)bbox);
        BoundingBox boundingBox = this.regionService.boundingBox();
        Assertions.assertThat((Object)boundingBox.getSouthWest()).isEqualTo((Object)Coordinates.valueOf((double)minLat_Y, (double)minLon_X));
        Assertions.assertThat((Object)boundingBox.getNorthEast()).isEqualTo((Object)Coordinates.valueOf((double)maxLat_Y, (double)maxLon_X));
    }
}

