/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.vehiclerouting.domain;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.optaweb.vehiclerouting.domain.CountryCodeValidator;

class CountryCodeValidatorTest {
    CountryCodeValidatorTest() {
    }

    @Test
    void should_fail_on_invalid_country_codes() {
        Assertions.assertThatNullPointerException().isThrownBy(() -> CountryCodeValidator.validate(null));
        Assertions.assertThatIllegalArgumentException().isThrownBy(() -> CountryCodeValidator.validate(Arrays.asList("XX")));
        Assertions.assertThatIllegalArgumentException().isThrownBy(() -> CountryCodeValidator.validate(Arrays.asList("CZE")));
        Assertions.assertThatIllegalArgumentException().isThrownBy(() -> CountryCodeValidator.validate(Arrays.asList("D")));
        Assertions.assertThatIllegalArgumentException().isThrownBy(() -> CountryCodeValidator.validate(Arrays.asList("")));
        Assertions.assertThatIllegalArgumentException().isThrownBy(() -> CountryCodeValidator.validate(Arrays.asList("US", "XY", "CA")));
    }

    @Test
    void should_ignore_case_and_convert_to_upper_case() {
        Assertions.assertThat((List)CountryCodeValidator.validate(Arrays.asList("us"))).containsExactly((Object[])new String[]{"US"});
    }

    @Test
    void should_allow_multiple_values() {
        Assertions.assertThat((List)CountryCodeValidator.validate(Arrays.asList("US", "ca"))).containsExactly((Object[])new String[]{"US", "CA"});
    }

    @Test
    void should_allow_empty_list() {
        Assertions.assertThat((List)CountryCodeValidator.validate(new ArrayList())).isEmpty();
    }
}

