/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.vehiclerouting.plugin.planner;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.LongStream;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.optaweb.vehiclerouting.plugin.planner.SolutionPublisher;
import org.optaweb.vehiclerouting.plugin.planner.domain.PlanningDepot;
import org.optaweb.vehiclerouting.plugin.planner.domain.PlanningLocation;
import org.optaweb.vehiclerouting.plugin.planner.domain.PlanningVehicle;
import org.optaweb.vehiclerouting.plugin.planner.domain.PlanningVehicleFactory;
import org.optaweb.vehiclerouting.plugin.planner.domain.PlanningVisit;
import org.optaweb.vehiclerouting.plugin.planner.domain.PlanningVisitFactory;
import org.optaweb.vehiclerouting.plugin.planner.domain.SolutionFactory;
import org.optaweb.vehiclerouting.plugin.planner.domain.Standstill;
import org.optaweb.vehiclerouting.plugin.planner.domain.VehicleRoutingSolution;
import org.optaweb.vehiclerouting.service.route.RouteChangedEvent;
import org.optaweb.vehiclerouting.service.route.ShallowRoute;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;

@ExtendWith(value={MockitoExtension.class})
class SolutionPublisherTest {
    @Mock
    private ApplicationEventPublisher publisher;
    @InjectMocks
    private SolutionPublisher solutionPublisher;

    SolutionPublisherTest() {
    }

    @Test
    void should_covert_solution_to_event_and_publish_it() {
        this.solutionPublisher.publishSolution(SolutionFactory.emptySolution());
        ((ApplicationEventPublisher)Mockito.verify((Object)this.publisher)).publishEvent((ApplicationEvent)Mockito.any(RouteChangedEvent.class));
    }

    @Test
    void empty_solution_should_have_zero_routes_vehicles_etc() {
        VehicleRoutingSolution solution = SolutionFactory.emptySolution();
        RouteChangedEvent event = SolutionPublisher.solutionToEvent((VehicleRoutingSolution)solution, (Object)this);
        Assertions.assertThat((List)event.vehicleIds()).isEmpty();
        Assertions.assertThat((Optional)event.depotId()).isEmpty();
        Assertions.assertThat((List)event.visitIds()).isEmpty();
        Assertions.assertThat((Iterable)event.routes()).isEmpty();
        Assertions.assertThat((String)event.distance()).isEqualTo("0h 0m 0s");
    }

    @Test
    void solution_with_vehicles_and_no_depot_should_have_zero_routes() {
        long vehicleId = 1L;
        PlanningVehicle vehicle = PlanningVehicleFactory.vehicle((long)vehicleId);
        VehicleRoutingSolution solution = SolutionFactory.solutionFromVisits(Collections.singletonList(vehicle), null, Collections.emptyList());
        RouteChangedEvent event = SolutionPublisher.solutionToEvent((VehicleRoutingSolution)solution, (Object)this);
        Assertions.assertThat((List)event.vehicleIds()).containsExactly((Object[])new Long[]{vehicleId});
        Assertions.assertThat((Optional)event.depotId()).isEmpty();
        Assertions.assertThat((List)event.visitIds()).isEmpty();
        Assertions.assertThat((Iterable)event.routes()).isEmpty();
        Assertions.assertThat((String)event.distance()).isEqualTo("0h 0m 0s");
    }

    @Test
    void nonempty_solution_without_vehicles_should_have_zero_routes_but_contain_visits() {
        long depotId = 1L;
        long visitId = 2L;
        VehicleRoutingSolution solution = SolutionFactory.solutionFromLocations(Collections.emptyList(), (PlanningDepot)new PlanningDepot(new PlanningLocation(depotId, 1.0, 1.0)), Collections.singletonList(new PlanningLocation(visitId, 2.0, 2.0)));
        RouteChangedEvent event = SolutionPublisher.solutionToEvent((VehicleRoutingSolution)solution, (Object)this);
        Assertions.assertThat((List)event.vehicleIds()).isEmpty();
        Assertions.assertThat((Optional)event.depotId()).contains((Object)depotId);
        Assertions.assertThat((List)event.visitIds()).containsExactly((Object[])new Long[]{visitId});
        Assertions.assertThat((Iterable)event.routes()).isEmpty();
        Assertions.assertThat((String)event.distance()).isEqualTo("0h 0m 0s");
    }

    @Test
    void initialized_solution_should_have_one_route_per_vehicle() {
        long vehicleId1 = 1001L;
        long vehicleId2 = 2001L;
        PlanningVehicle vehicle1 = PlanningVehicleFactory.vehicle((long)vehicleId1);
        PlanningVehicle vehicle2 = PlanningVehicleFactory.vehicle((long)vehicleId2);
        long depotId = 1L;
        long visitId1 = 2L;
        long visitId2 = 3L;
        PlanningDepot depot = new PlanningDepot(new PlanningLocation(depotId, 1.0, 1.0));
        PlanningVisit visit1 = PlanningVisitFactory.visit((PlanningLocation)new PlanningLocation(visitId1, 2.0, 2.0));
        PlanningVisit visit2 = PlanningVisitFactory.visit((PlanningLocation)new PlanningLocation(visitId2, 0.2, 0.2));
        VehicleRoutingSolution solution = SolutionFactory.solutionFromVisits(Arrays.asList(vehicle1, vehicle2), (PlanningDepot)depot, Arrays.asList(visit1, visit2));
        for (PlanningVehicle vehicle : solution.getVehicleList()) {
            vehicle.setNextVisit(visit1);
            visit1.setPreviousStandstill((Standstill)vehicle);
        }
        visit1.setNextVisit(visit2);
        visit2.setPreviousStandstill((Standstill)visit1);
        RouteChangedEvent event = SolutionPublisher.solutionToEvent((VehicleRoutingSolution)solution, (Object)this);
        Assertions.assertThat((Iterable)event.routes()).hasSameSizeAs((Iterable)solution.getVehicleList());
        Assertions.assertThat((LongStream)event.routes().stream().mapToLong(value -> value.vehicleId)).containsExactlyInAnyOrder((Object[])new Long[]{vehicleId1, vehicleId2});
        for (ShallowRoute route : event.routes()) {
            Assertions.assertThat((Long)route.depotId).isEqualTo((Object)depot.getId());
            Assertions.assertThat((List)route.visitIds).containsExactly((Object[])new Long[]{visitId1, visitId2});
        }
        Assertions.assertThat((List)event.vehicleIds()).containsExactlyInAnyOrder((Object[])new Long[]{vehicleId1, vehicleId2});
        Assertions.assertThat((Optional)event.depotId()).contains((Object)depotId);
        Assertions.assertThat((List)event.visitIds()).containsExactlyInAnyOrder((Object[])new Long[]{visitId1, visitId2});
        Assertions.assertThat((String)event.distance()).isEqualTo("0h 0m 0s");
    }

    @Test
    void fail_fast_if_vehicles_next_visit_doesnt_exist() {
        PlanningVehicle vehicle = PlanningVehicleFactory.vehicle((long)1L);
        vehicle.setNextVisit(PlanningVisitFactory.visit((PlanningLocation)new PlanningLocation(2L, 2.0, 2.0)));
        VehicleRoutingSolution solution = SolutionFactory.solutionFromLocations(Collections.singletonList(vehicle), (PlanningDepot)new PlanningDepot(new PlanningLocation(1L, 1.0, 1.0)), Collections.singletonList(new PlanningLocation(3L, 3.0, 3.0)));
        Assertions.assertThatIllegalArgumentException().isThrownBy(() -> SolutionPublisher.solutionToEvent((VehicleRoutingSolution)solution, (Object)this)).withMessageContaining("Visit");
    }

    @Test
    void vehicle_without_a_depot_is_illegal_if_depot_exists() {
        PlanningDepot depot = new PlanningDepot(new PlanningLocation(1L, 1.0, 1.0));
        PlanningVehicle vehicle = PlanningVehicleFactory.vehicle((long)1L);
        VehicleRoutingSolution solution = SolutionFactory.solutionFromVisits(Collections.singletonList(vehicle), (PlanningDepot)depot, Collections.emptyList());
        vehicle.setDepot(null);
        Assertions.assertThatIllegalArgumentException().isThrownBy(() -> SolutionPublisher.solutionToEvent((VehicleRoutingSolution)solution, (Object)this)).withMessageContaining("Vehicle");
    }
}

