/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.vehiclerouting.plugin.planner.domain;

import java.util.Collections;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.optaweb.vehiclerouting.plugin.planner.domain.PlanningDepot;
import org.optaweb.vehiclerouting.plugin.planner.domain.PlanningLocation;
import org.optaweb.vehiclerouting.plugin.planner.domain.PlanningVehicle;
import org.optaweb.vehiclerouting.plugin.planner.domain.PlanningVisit;
import org.optaweb.vehiclerouting.plugin.planner.domain.PlanningVisitFactory;
import org.optaweb.vehiclerouting.plugin.planner.domain.SolutionFactory;
import org.optaweb.vehiclerouting.plugin.planner.domain.VehicleRoutingSolution;

class SolutionFactoryTest {
    SolutionFactoryTest() {
    }

    @Test
    void empty_solution_should_be_empty() {
        VehicleRoutingSolution solution = SolutionFactory.emptySolution();
        Assertions.assertThat((List)solution.getLocationList()).isEmpty();
        Assertions.assertThat((List)solution.getVisitList()).isEmpty();
        Assertions.assertThat((List)solution.getDepotList()).isEmpty();
        Assertions.assertThat((List)solution.getVehicleList()).isEmpty();
        Assertions.assertThat((String)solution.getDistanceUnitOfMeasurement()).isEqualTo("sec");
    }

    @Test
    void solution_created_from_vehicles_depot_and_visits_should_be_consistent() {
        PlanningVehicle vehicle = new PlanningVehicle();
        PlanningLocation depotLocation = new PlanningLocation(1L, 1.0, 1.0);
        PlanningDepot depot = new PlanningDepot();
        depot.setLocation(depotLocation);
        PlanningVisit visit = PlanningVisitFactory.visit((PlanningLocation)new PlanningLocation(2L, 2.0, 2.0));
        VehicleRoutingSolution solutionWithDepot = SolutionFactory.solutionFromVisits(Collections.singletonList(vehicle), (PlanningDepot)depot, Collections.singletonList(visit));
        Assertions.assertThat((List)solutionWithDepot.getVehicleList()).containsExactly((Object[])new PlanningVehicle[]{vehicle});
        Assertions.assertThat((Comparable)vehicle.getDepot()).isEqualTo((Object)depot);
        Assertions.assertThat((List)solutionWithDepot.getDepotList()).containsExactly((Object[])new PlanningDepot[]{depot});
        Assertions.assertThat((List)solutionWithDepot.getVisitList()).hasSize(1);
        Assertions.assertThat((List)solutionWithDepot.getVisitList()).containsExactly((Object[])new PlanningVisit[]{visit});
        Assertions.assertThat((Comparable)((PlanningVisit)solutionWithDepot.getVisitList().get(0)).getLocation()).isEqualTo((Object)visit.getLocation());
        Assertions.assertThat((List)solutionWithDepot.getLocationList()).containsExactlyInAnyOrder((Object[])new PlanningLocation[]{depotLocation, visit.getLocation()});
        VehicleRoutingSolution solutionWithNoDepot = SolutionFactory.solutionFromVisits(Collections.singletonList(vehicle), null, Collections.emptyList());
        Assertions.assertThat((List)solutionWithNoDepot.getDepotList()).isEmpty();
    }
}

