/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.vehiclerouting.plugin.planner.domain;

import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.optaplanner.core.api.score.buildin.hardsoftlong.HardSoftLongScore;
import org.optaweb.vehiclerouting.plugin.planner.domain.SolutionFactory;
import org.optaweb.vehiclerouting.plugin.planner.domain.VehicleRoutingSolution;

class VehicleRoutingSolutionTest {
    private VehicleRoutingSolution solution;

    VehicleRoutingSolutionTest() {
    }

    @BeforeEach
    void setUp() {
        this.solution = SolutionFactory.emptySolution();
    }

    @Test
    void should_return_distance_in_time() {
        this.solution.setDistanceUnitOfMeasurement("sec");
        this.solution.setScore(HardSoftLongScore.of((long)0L, (long)-3661001L));
        String distanceString = this.solution.getDistanceString(null);
        Assertions.assertThat((String)distanceString).isEqualTo("1h 1m 1s 1ms");
    }

    @Test
    void should_return_distance_in_meters() {
        this.solution.setDistanceUnitOfMeasurement("meter");
        this.solution.setScore(HardSoftLongScore.of((long)0L, (long)-100100L));
        String distanceString = this.solution.getDistanceString(null);
        Assertions.assertThat((String)distanceString).isEqualTo("100km 100m");
    }
}

