/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.vehiclerouting.plugin.websocket;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.optaweb.vehiclerouting.domain.Coordinates;
import org.optaweb.vehiclerouting.domain.Location;
import org.optaweb.vehiclerouting.domain.Route;
import org.optaweb.vehiclerouting.domain.RouteWithTrack;
import org.optaweb.vehiclerouting.domain.RoutingPlan;
import org.optaweb.vehiclerouting.domain.Vehicle;
import org.optaweb.vehiclerouting.domain.VehicleFactory;
import org.optaweb.vehiclerouting.plugin.websocket.PortableCoordinates;
import org.optaweb.vehiclerouting.plugin.websocket.PortableLocation;
import org.optaweb.vehiclerouting.plugin.websocket.PortableRoute;
import org.optaweb.vehiclerouting.plugin.websocket.PortableRoutingPlan;
import org.optaweb.vehiclerouting.plugin.websocket.PortableRoutingPlanFactory;
import org.optaweb.vehiclerouting.plugin.websocket.PortableVehicle;

class PortableRoutingPlanFactoryTest {
    PortableRoutingPlanFactoryTest() {
    }

    @Test
    void portable_routing_plan_empty() {
        PortableRoutingPlan portablePlan = PortableRoutingPlanFactory.fromRoutingPlan((RoutingPlan)RoutingPlan.empty());
        Assertions.assertThat((String)portablePlan.getDistance()).isEmpty();
        Assertions.assertThat((List)portablePlan.getVehicles()).isEmpty();
        Assertions.assertThat((Object)portablePlan.getDepot()).isNull();
        Assertions.assertThat((List)portablePlan.getRoutes()).isEmpty();
    }

    @Test
    void portable_routing_plan_with_two_routes() {
        Coordinates coordinates1 = Coordinates.valueOf((double)0.0, (double)0.1);
        Coordinates coordinates2 = Coordinates.valueOf((double)2.0, (double)-0.2);
        Coordinates coordinates3 = Coordinates.valueOf((double)3.3, (double)-3.3);
        Coordinates checkpoint12 = Coordinates.valueOf((double)12.0, (double)12.0);
        Coordinates checkpoint21 = Coordinates.valueOf((double)21.0, (double)21.0);
        Coordinates checkpoint13 = Coordinates.valueOf((double)13.0, (double)13.0);
        Coordinates checkpoint31 = Coordinates.valueOf((double)31.0, (double)31.0);
        List<Coordinates> segment12 = Arrays.asList(coordinates1, checkpoint12, coordinates2);
        List<Coordinates> segment21 = Arrays.asList(coordinates2, checkpoint21, coordinates1);
        List<Coordinates> segment13 = Arrays.asList(coordinates1, checkpoint13, coordinates3);
        List<Coordinates> segment31 = Arrays.asList(coordinates3, checkpoint31, coordinates1);
        Location location1 = new Location(1L, coordinates1);
        Location location2 = new Location(2L, coordinates2);
        Location location3 = new Location(3L, coordinates3);
        String distance = "xy";
        Vehicle vehicle1 = VehicleFactory.createVehicle((long)1L, (String)"Vehicle 1", (int)100);
        Vehicle vehicle2 = VehicleFactory.createVehicle((long)2L, (String)"Vehicle 2", (int)200);
        RouteWithTrack route1 = new RouteWithTrack(new Route(vehicle1, location1, Collections.singletonList(location2)), Arrays.asList(segment12, segment21));
        RouteWithTrack route2 = new RouteWithTrack(new Route(vehicle2, location1, Collections.singletonList(location3)), Arrays.asList(segment13, segment31));
        RoutingPlan routingPlan = new RoutingPlan("xy", Arrays.asList(vehicle1, vehicle2), location1, Arrays.asList(location2, location3), Arrays.asList(route1, route2));
        PortableRoutingPlan portableRoutingPlan = PortableRoutingPlanFactory.fromRoutingPlan((RoutingPlan)routingPlan);
        Assertions.assertThat((String)portableRoutingPlan.getDistance()).isEqualTo("xy");
        Assertions.assertThat((Object)portableRoutingPlan.getDepot()).isEqualTo((Object)PortableLocation.fromLocation((Location)location1));
        Assertions.assertThat((List)portableRoutingPlan.getVisits()).containsExactlyInAnyOrder((Object[])new PortableLocation[]{PortableLocation.fromLocation((Location)location2), PortableLocation.fromLocation((Location)location3)});
        Assertions.assertThat((List)portableRoutingPlan.getRoutes()).hasSize(2);
        Assertions.assertThat((List)portableRoutingPlan.getVehicles()).containsExactlyInAnyOrder((Object[])new PortableVehicle[]{PortableVehicle.fromVehicle((Vehicle)vehicle1), PortableVehicle.fromVehicle((Vehicle)vehicle2)});
        PortableRoute portableRoute1 = (PortableRoute)portableRoutingPlan.getRoutes().get(0);
        Assertions.assertThat((Object)portableRoute1.getVehicle()).isEqualTo((Object)PortableVehicle.fromVehicle((Vehicle)vehicle1));
        Assertions.assertThat((Object)portableRoute1.getDepot()).isEqualTo((Object)PortableLocation.fromLocation((Location)location1));
        Assertions.assertThat((List)portableRoute1.getVisits()).containsExactly((Object[])new PortableLocation[]{PortableLocation.fromLocation((Location)location2)});
        Assertions.assertThat((List)portableRoute1.getTrack()).hasSize(2);
        Assertions.assertThat((List)((List)portableRoute1.getTrack().get(0))).containsExactly((Object[])new PortableCoordinates[]{PortableCoordinates.fromCoordinates((Coordinates)location1.coordinates()), PortableCoordinates.fromCoordinates((Coordinates)checkpoint12), PortableCoordinates.fromCoordinates((Coordinates)location2.coordinates())});
        Assertions.assertThat((List)((List)portableRoute1.getTrack().get(1))).containsExactly((Object[])new PortableCoordinates[]{PortableCoordinates.fromCoordinates((Coordinates)location2.coordinates()), PortableCoordinates.fromCoordinates((Coordinates)checkpoint21), PortableCoordinates.fromCoordinates((Coordinates)location1.coordinates())});
        PortableRoute portableRoute2 = (PortableRoute)portableRoutingPlan.getRoutes().get(1);
        Assertions.assertThat((Object)portableRoute2.getVehicle()).isEqualTo((Object)PortableVehicle.fromVehicle((Vehicle)vehicle2));
        Assertions.assertThat((Object)portableRoute2.getDepot()).isEqualTo((Object)PortableLocation.fromLocation((Location)location1));
        Assertions.assertThat((List)portableRoute2.getVisits()).containsExactly((Object[])new PortableLocation[]{PortableLocation.fromLocation((Location)location3)});
        Assertions.assertThat((List)portableRoute2.getTrack()).hasSize(2);
        Assertions.assertThat((List)((List)portableRoute2.getTrack().get(0))).containsExactly((Object[])new PortableCoordinates[]{PortableCoordinates.fromCoordinates((Coordinates)location1.coordinates()), PortableCoordinates.fromCoordinates((Coordinates)checkpoint13), PortableCoordinates.fromCoordinates((Coordinates)location3.coordinates())});
        Assertions.assertThat((List)((List)portableRoute2.getTrack().get(1))).containsExactly((Object[])new PortableCoordinates[]{PortableCoordinates.fromCoordinates((Coordinates)location3.coordinates()), PortableCoordinates.fromCoordinates((Coordinates)checkpoint31), PortableCoordinates.fromCoordinates((Coordinates)location1.coordinates())});
    }
}

