/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.vehiclerouting.plugin.websocket;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.optaweb.vehiclerouting.domain.Vehicle;
import org.optaweb.vehiclerouting.domain.VehicleFactory;
import org.optaweb.vehiclerouting.plugin.websocket.PortableVehicle;
import org.springframework.boot.test.json.JacksonTester;
import org.springframework.boot.test.json.JsonContentAssert;

class PortableVehicleTest {
    private JacksonTester<PortableVehicle> json;

    PortableVehicleTest() {
    }

    @BeforeEach
    void setUp() {
        JacksonTester.initFields((Object)this, (ObjectMapper)new ObjectMapper());
    }

    @Test
    void marshall_to_json() throws IOException {
        long id = 321L;
        String name = "Pink: {XY-123} \"B\"";
        int capacity = 78;
        PortableVehicle portableVehicle = new PortableVehicle(id, name, capacity);
        String jsonTemplate = "{\"id\":%d,\"name\":\"%s\",\"capacity\":%d}";
        ((JsonContentAssert)Assertions.assertThat((AssertProvider)this.json.write((Object)portableVehicle))).isEqualToJson((CharSequence)String.format(jsonTemplate, id, name.replaceAll("\"", "\\\\\""), capacity));
    }

    @Test
    void constructor_params_must_not_be_null() {
        Assertions.assertThatNullPointerException().isThrownBy(() -> new PortableVehicle(1L, null, 2));
    }

    @Test
    void fromVehicle() {
        long id = 321L;
        String name = "Pink XY-123 B";
        int capacity = 31;
        PortableVehicle portableVehicle = PortableVehicle.fromVehicle((Vehicle)VehicleFactory.createVehicle((long)id, (String)name, (int)capacity));
        Assertions.assertThat((long)portableVehicle.getId()).isEqualTo(id);
        Assertions.assertThat((String)portableVehicle.getName()).isEqualTo(name);
        Assertions.assertThat((int)portableVehicle.getCapacity()).isEqualTo(capacity);
        Assertions.assertThatNullPointerException().isThrownBy(() -> PortableVehicle.fromVehicle(null)).withMessageContaining("vehicle");
    }

    @Test
    void equals_hashCode_toString() {
        long id = 123456L;
        String name = "x y";
        int capacity = 444111;
        PortableVehicle portableVehicle = new PortableVehicle(id, name, capacity);
        Assertions.assertThat((Object)portableVehicle).isNotEqualTo(null);
        Assertions.assertThat((Object)portableVehicle).isNotEqualTo((Object)VehicleFactory.createVehicle((long)id, (String)name, (int)capacity));
        Assertions.assertThat((Object)portableVehicle).isNotEqualTo((Object)new PortableVehicle(id + 1L, name, capacity));
        Assertions.assertThat((Object)portableVehicle).isNotEqualTo((Object)new PortableVehicle(id, name + "z", capacity));
        Assertions.assertThat((Object)portableVehicle).isNotEqualTo((Object)new PortableVehicle(id, name, capacity + 1));
        Assertions.assertThat((Object)portableVehicle).isEqualTo((Object)portableVehicle);
        Assertions.assertThat((Object)portableVehicle).isEqualTo((Object)new PortableVehicle(id, name, capacity));
        Assertions.assertThat((Object)portableVehicle).hasSameHashCodeAs((Object)new PortableVehicle(id, name, capacity));
        Assertions.assertThat((String)portableVehicle.toString()).contains(new CharSequence[]{String.valueOf(id), name, String.valueOf(capacity)});
    }
}

