/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.vehiclerouting.service.demo.dataset;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.optaweb.vehiclerouting.domain.Coordinates;
import org.optaweb.vehiclerouting.domain.LocationData;
import org.optaweb.vehiclerouting.domain.RoutingProblem;
import org.optaweb.vehiclerouting.service.demo.dataset.DataSet;
import org.optaweb.vehiclerouting.service.demo.dataset.DataSetLocation;
import org.optaweb.vehiclerouting.service.demo.dataset.DataSetMarshaller;

class DataSetMarshallerTest {
    DataSetMarshallerTest() {
    }

    @Test
    void unmarshal_data_set() throws IOException {
        DataSet dataSet;
        try (InputStream inputStream = DataSetMarshallerTest.class.getResourceAsStream("test-belgium.yaml");){
            dataSet = new DataSetMarshaller().unmarshalToDataSet((Reader)new InputStreamReader(inputStream, StandardCharsets.UTF_8));
        }
        Assertions.assertThat((Object)dataSet).isNotNull();
        Assertions.assertThat((String)dataSet.getName()).isEqualTo("Belgium test");
        Assertions.assertThat((Object)dataSet.getDepot()).isNotNull();
        Assertions.assertThat((String)dataSet.getDepot().getLabel()).isEqualTo("Brussels");
        Assertions.assertThat((double)dataSet.getDepot().getLatitude()).isEqualTo(50.85);
        Assertions.assertThat((double)dataSet.getDepot().getLongitude()).isEqualTo(4.35);
        Assertions.assertThat((List)dataSet.getVisits()).extracting("label").containsExactlyInAnyOrder(new Object[]{"Aalst", "Ch\u00e2telet", "La Louvi\u00e8re", "Sint-Niklaas", "Ypres"});
    }

    @Test
    void marshal_data_set() {
        DataSet dataSet = new DataSet();
        String name = "Test data set";
        dataSet.setName(name);
        DataSetLocation depot = new DataSetLocation("Depot", -1.1, -9.9);
        DataSetLocation location1 = new DataSetLocation("Location 1", 1.0, 0.1);
        DataSetLocation location2 = new DataSetLocation("Location 2", 2.0, 0.2);
        dataSet.setDepot(depot);
        dataSet.setVisits(Arrays.asList(location1, location2));
        String yaml = new DataSetMarshaller().marshal(dataSet);
        ((AbstractStringAssert)Assertions.assertThat((String)yaml).contains(new CharSequence[]{"name: \"" + name})).contains(new CharSequence[]{depot.getLabel(), location1.getLabel(), location2.getLabel()});
    }

    @Test
    void should_rethrow_exception_from_object_mapper() throws IOException {
        ObjectMapper objectMapper = (ObjectMapper)Mockito.mock(ObjectMapper.class);
        Mockito.when((Object)objectMapper.readValue((Reader)ArgumentMatchers.any(Reader.class), (Class)ArgumentMatchers.eq(DataSet.class))).thenThrow(IOException.class);
        Assertions.assertThatIllegalStateException().isThrownBy(() -> new DataSetMarshaller(objectMapper).unmarshalToDataSet((Reader)Mockito.mock(Reader.class))).withRootCauseExactlyInstanceOf(IOException.class);
        Mockito.when((Object)objectMapper.writeValueAsString(ArgumentMatchers.any(DataSet.class))).thenThrow(JsonProcessingException.class);
        Assertions.assertThatIllegalStateException().isThrownBy(() -> new DataSetMarshaller(objectMapper).marshal(new DataSet())).withRootCauseExactlyInstanceOf(JsonProcessingException.class);
    }

    @Test
    void location_conversion() {
        double lat = -1.0;
        double lng = 50.2;
        String description = "some location";
        DataSetLocation dataSetLocation = DataSetMarshaller.toDataSet((LocationData)new LocationData(Coordinates.valueOf((double)lat, (double)lng), description));
        Assertions.assertThat((double)dataSetLocation.getLatitude()).isEqualTo(lat);
        Assertions.assertThat((double)dataSetLocation.getLongitude()).isEqualTo(lng);
        Assertions.assertThat((String)dataSetLocation.getLabel()).isEqualTo(description);
        LocationData location = DataSetMarshaller.toDomain((DataSetLocation)dataSetLocation);
        Assertions.assertThat((Object)location).isEqualTo((Object)new LocationData(Coordinates.valueOf((double)lat, (double)lng), description));
    }

    @Test
    void routing_problem_conversion() {
        LocationData depot = new LocationData(Coordinates.valueOf((double)60.1, (double)5.78), "Depot");
        LocationData visit = new LocationData(Coordinates.valueOf((double)1.06, (double)8.75), "Visit");
        List<LocationData> visits = Arrays.asList(visit);
        String name = "some data set";
        DataSet dataSet = DataSetMarshaller.toDataSet((RoutingProblem)new RoutingProblem(name, depot, visits));
        Assertions.assertThat((String)dataSet.getName()).isEqualTo(name);
        Assertions.assertThat((Object)DataSetMarshaller.toDomain((DataSetLocation)dataSet.getDepot())).isEqualTo((Object)depot);
        Assertions.assertThat((List)dataSet.getVisits()).hasSameSizeAs(visits);
        Assertions.assertThat((Object)DataSetMarshaller.toDomain((DataSetLocation)((DataSetLocation)dataSet.getVisits().get(0)))).isEqualTo((Object)visit);
        RoutingProblem routingProblem = DataSetMarshaller.toDomain((DataSet)dataSet);
        Assertions.assertThat((String)routingProblem.name()).isEqualTo(name);
        Assertions.assertThat((Optional)routingProblem.depot()).contains((Object)depot);
        Assertions.assertThat((List)routingProblem.visits()).containsExactly((Object[])new LocationData[]{visit});
    }
}

