/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.vehiclerouting.service.vehicle;

import java.util.Arrays;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.optaweb.vehiclerouting.domain.Vehicle;
import org.optaweb.vehiclerouting.domain.VehicleFactory;
import org.optaweb.vehiclerouting.service.location.RouteOptimizer;
import org.optaweb.vehiclerouting.service.vehicle.VehicleRepository;
import org.optaweb.vehiclerouting.service.vehicle.VehicleService;

@ExtendWith(value={MockitoExtension.class})
class VehicleServiceTest {
    @Captor
    private ArgumentCaptor<Vehicle> vehicleArgumentCaptor;
    @Mock
    private RouteOptimizer optimizer;
    @Mock
    private VehicleRepository vehicleRepository;
    @InjectMocks
    private VehicleService vehicleService;

    VehicleServiceTest() {
    }

    @Test
    void addVehicle() {
        long vehicleId = 63L;
        Mockito.when((Object)this.vehicleRepository.nextId()).thenReturn((Object)63L);
        String name = "Veh5";
        int capacity = 49;
        Vehicle vehicle = VehicleFactory.createVehicle((long)63L, (String)"Veh5", (int)49);
        Mockito.when((Object)this.vehicleRepository.createVehicle("Vehicle 63", 10)).thenReturn((Object)vehicle);
        this.vehicleService.addVehicle();
        ((RouteOptimizer)Mockito.verify((Object)this.optimizer)).addVehicle((Vehicle)this.vehicleArgumentCaptor.capture());
        Vehicle newVehicle = (Vehicle)this.vehicleArgumentCaptor.getValue();
        Assertions.assertThat((long)newVehicle.id()).isEqualTo(63L);
        Assertions.assertThat((String)newVehicle.name()).isEqualTo("Veh5");
        Assertions.assertThat((int)newVehicle.capacity()).isEqualTo(49);
    }

    @Test
    void removeVehicle() {
        long vehicleId = 8L;
        Vehicle vehicle = VehicleFactory.testVehicle((long)8L);
        Mockito.when((Object)this.vehicleRepository.removeVehicle(8L)).thenReturn((Object)vehicle);
        this.vehicleService.removeVehicle(8L);
        ((VehicleRepository)Mockito.verify((Object)this.vehicleRepository)).removeVehicle(8L);
        ((RouteOptimizer)Mockito.verify((Object)this.optimizer)).removeVehicle(vehicle);
    }

    @Test
    void removeAnyVehicle_should_remove_oldest_vehicle() {
        long vehicleId1 = 1L;
        long vehicleId2 = 2L;
        long vehicleId3 = 3L;
        Vehicle vehicle1 = VehicleFactory.testVehicle((long)1L);
        Vehicle vehicle2 = VehicleFactory.testVehicle((long)2L);
        Vehicle vehicle3 = VehicleFactory.testVehicle((long)3L);
        Mockito.when((Object)this.vehicleRepository.vehicles()).thenReturn(Arrays.asList(vehicle3, vehicle1, vehicle2));
        Mockito.when((Object)this.vehicleRepository.removeVehicle(1L)).thenReturn((Object)vehicle1);
        this.vehicleService.removeAnyVehicle();
        ((VehicleRepository)Mockito.verify((Object)this.vehicleRepository)).removeVehicle(1L);
        ((RouteOptimizer)Mockito.verify((Object)this.optimizer)).removeVehicle(vehicle1);
    }

    @Test
    void removeAll() {
        this.vehicleService.removeAll();
        ((RouteOptimizer)Mockito.verify((Object)this.optimizer)).removeAllVehicles();
        ((VehicleRepository)Mockito.verify((Object)this.vehicleRepository)).removeAll();
    }

    @Test
    void changeCapacity() {
        long vehicleId = 1L;
        int capacity = 123;
        Vehicle originalVehicle = VehicleFactory.createVehicle((long)1L, (String)"1", (int)113);
        Mockito.when((Object)this.vehicleRepository.find(Long.valueOf(1L))).thenReturn(Optional.of(originalVehicle));
        this.vehicleService.changeCapacity(Long.valueOf(1L), 123);
        ((VehicleRepository)Mockito.verify((Object)this.vehicleRepository)).update((Vehicle)this.vehicleArgumentCaptor.capture());
        Assertions.assertThat((long)((Vehicle)this.vehicleArgumentCaptor.getValue()).id()).isEqualTo(1L);
        Assertions.assertThat((int)((Vehicle)this.vehicleArgumentCaptor.getValue()).capacity()).isEqualTo(123);
        ((RouteOptimizer)Mockito.verify((Object)this.optimizer)).changeCapacity((Vehicle)this.vehicleArgumentCaptor.capture());
        Assertions.assertThat((int)((Vehicle)this.vehicleArgumentCaptor.getValue()).capacity()).isEqualTo(123);
    }
}

