/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.vehiclerouting.domain;

import java.math.BigDecimal;
import java.util.Objects;

public class Coordinates {
    private final BigDecimal latitude;
    private final BigDecimal longitude;

    public Coordinates(BigDecimal latitude, BigDecimal longitude) {
        this.latitude = Objects.requireNonNull(latitude);
        this.longitude = Objects.requireNonNull(longitude);
    }

    public static Coordinates valueOf(double latitude, double longitude) {
        return new Coordinates(BigDecimal.valueOf(latitude), BigDecimal.valueOf(longitude));
    }

    public BigDecimal latitude() {
        return this.latitude;
    }

    public BigDecimal longitude() {
        return this.longitude;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Coordinates coordinates = (Coordinates)o;
        return this.latitude.compareTo(coordinates.latitude) == 0 && this.longitude.compareTo(coordinates.longitude) == 0;
    }

    public int hashCode() {
        return Objects.hash(this.latitude, this.longitude);
    }

    public String toString() {
        return "[" + this.latitude.toPlainString() + ", " + this.longitude.toPlainString() + ']';
    }
}

