/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.vehiclerouting.domain;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.optaweb.vehiclerouting.domain.Location;
import org.optaweb.vehiclerouting.domain.Route;
import org.optaweb.vehiclerouting.domain.RouteWithTrack;
import org.optaweb.vehiclerouting.domain.Vehicle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RoutingPlan {
    private static final Logger logger = LoggerFactory.getLogger(RoutingPlan.class);
    private final String distance;
    private final List<Vehicle> vehicles;
    private final Location depot;
    private final List<Location> visits;
    private final List<RouteWithTrack> routes;

    public RoutingPlan(String distance, List<Vehicle> vehicles, Location depot, List<Location> visits, List<RouteWithTrack> routes) {
        this.distance = Objects.requireNonNull(distance);
        this.vehicles = new ArrayList<Vehicle>((Collection)Objects.requireNonNull(vehicles));
        this.depot = depot;
        this.visits = new ArrayList<Location>((Collection)Objects.requireNonNull(visits));
        this.routes = new ArrayList<RouteWithTrack>((Collection)Objects.requireNonNull(routes));
        if (depot == null) {
            if (!routes.isEmpty()) {
                throw new IllegalArgumentException("Routes must be empty when depot is null");
            }
        } else {
            if (routes.size() != vehicles.size()) {
                throw new IllegalArgumentException(RoutingPlan.describeVehiclesRoutesInconsistency("There must be exactly one route per vehicle", vehicles, routes));
            }
            if (RoutingPlan.haveDifferentVehicles(vehicles, routes)) {
                throw new IllegalArgumentException(RoutingPlan.describeVehiclesRoutesInconsistency("Some routes are assigned to non-existent vehicles", vehicles, routes));
            }
            if (!routes.isEmpty()) {
                List visited = routes.stream().map(Route::visits).flatMap(Collection::stream).collect(Collectors.toList());
                ArrayList<Location> unvisited = new ArrayList<Location>(visits);
                unvisited.removeAll(visited);
                if (!unvisited.isEmpty()) {
                    logger.warn("Some visits are unvisited: {}", unvisited);
                }
                visited.removeAll(visits);
                if (!visited.isEmpty()) {
                    throw new IllegalArgumentException("Some routes are going through visits that haven't been defined: " + visited);
                }
            }
        }
    }

    private static boolean haveDifferentVehicles(List<Vehicle> vehicles, List<RouteWithTrack> routes) {
        return routes.stream().map(Route::vehicle).anyMatch(vehicle -> !vehicles.contains(vehicle));
    }

    private static String describeVehiclesRoutesInconsistency(String cause, List<Vehicle> vehicles, List<? extends Route> routes) {
        List vehicleIdsFromRoutes = routes.stream().map(route -> route.vehicle().id()).collect(Collectors.toList());
        return cause + ":\n- Vehicles (" + vehicles.size() + "): " + vehicles + "\n- Routes' vehicleIds (" + routes.size() + "): " + vehicleIdsFromRoutes;
    }

    public static RoutingPlan empty() {
        return new RoutingPlan("", Collections.emptyList(), null, Collections.emptyList(), Collections.emptyList());
    }

    public String distance() {
        return this.distance;
    }

    public List<Vehicle> vehicles() {
        return Collections.unmodifiableList(this.vehicles);
    }

    public List<RouteWithTrack> routes() {
        return Collections.unmodifiableList(this.routes);
    }

    public List<Location> visits() {
        return Collections.unmodifiableList(this.visits);
    }

    public Optional<Location> depot() {
        return Optional.ofNullable(this.depot);
    }

    public boolean isEmpty() {
        return this.depot == null && this.vehicles.isEmpty();
    }
}

