/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.vehiclerouting.plugin.planner;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.optaweb.vehiclerouting.plugin.planner.domain.PlanningLocation;

class DistanceMap
implements Map<PlanningLocation, Double> {
    private final PlanningLocation location;
    private final Map<Long, Double> distanceMap;

    DistanceMap(PlanningLocation location, Map<Long, Double> distanceMap) {
        this.location = location;
        this.distanceMap = distanceMap;
    }

    @Override
    public int size() {
        return this.distanceMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.distanceMap.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.distanceMap.containsKey(((PlanningLocation)key).getId());
    }

    @Override
    public boolean containsValue(Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Double get(Object key) {
        if (!this.containsKey(key)) {
            throw new IllegalArgumentException("Distance from " + this.location + " to " + key + " hasn't been recorded.\nWe only know distances to " + this.distanceMap.keySet());
        }
        return this.distanceMap.get(((PlanningLocation)key).getId()) / 1000.0;
    }

    @Override
    public Double put(PlanningLocation key, Double value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Double remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(Map<? extends PlanningLocation, ? extends Double> m) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<PlanningLocation> keySet() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Collection<Double> values() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<Map.Entry<PlanningLocation, Double>> entrySet() {
        throw new UnsupportedOperationException();
    }
}

