/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.vehiclerouting.plugin.planner;

import java.util.ArrayList;
import java.util.List;
import org.optaweb.vehiclerouting.domain.Location;
import org.optaweb.vehiclerouting.domain.Vehicle;
import org.optaweb.vehiclerouting.plugin.planner.DistanceMap;
import org.optaweb.vehiclerouting.plugin.planner.SolutionPublisher;
import org.optaweb.vehiclerouting.plugin.planner.SolverManager;
import org.optaweb.vehiclerouting.plugin.planner.domain.PlanningDepot;
import org.optaweb.vehiclerouting.plugin.planner.domain.PlanningLocation;
import org.optaweb.vehiclerouting.plugin.planner.domain.PlanningVehicle;
import org.optaweb.vehiclerouting.plugin.planner.domain.PlanningVehicleFactory;
import org.optaweb.vehiclerouting.plugin.planner.domain.SolutionFactory;
import org.optaweb.vehiclerouting.service.location.DistanceMatrix;
import org.optaweb.vehiclerouting.service.location.RouteOptimizer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
class RouteOptimizerImpl
implements RouteOptimizer {
    private final SolverManager solverManager;
    private final SolutionPublisher solutionPublisher;
    private final List<PlanningVehicle> vehicles = new ArrayList<PlanningVehicle>();
    private final List<PlanningLocation> visits = new ArrayList<PlanningLocation>();
    private PlanningDepot depot;

    @Autowired
    RouteOptimizerImpl(SolverManager solverManager, SolutionPublisher solutionPublisher) {
        this.solverManager = solverManager;
        this.solutionPublisher = solutionPublisher;
    }

    @Override
    public void addLocation(Location domainLocation, DistanceMatrix distanceMatrix) {
        PlanningLocation location = new PlanningLocation(domainLocation);
        DistanceMap distanceMap = new DistanceMap(location, distanceMatrix.getRow(domainLocation));
        location.setTravelDistanceMap(distanceMap);
        if (this.depot == null) {
            this.depot = new PlanningDepot(location);
            this.publishSolution();
        } else {
            this.visits.add(location);
            if (this.vehicles.isEmpty()) {
                this.publishSolution();
            } else if (this.visits.size() == 1) {
                this.solverManager.startSolver(SolutionFactory.solutionFromLocations(this.vehicles, this.depot, this.visits));
            } else {
                this.solverManager.addLocation(location);
            }
        }
    }

    @Override
    public void removeLocation(Location domainLocation) {
        if (this.visits.isEmpty()) {
            if (this.depot == null) {
                throw new IllegalArgumentException("Cannot remove " + domainLocation + " because there are no locations");
            }
            if (!this.depot.getId().equals(domainLocation.id())) {
                throw new IllegalArgumentException("Cannot remove " + domainLocation + " because it doesn't exist");
            }
            this.depot = null;
            this.publishSolution();
        } else {
            if (this.depot.getId().equals(domainLocation.id())) {
                throw new IllegalStateException("You can only remove depot if there are no visits");
            }
            if (!this.visits.removeIf(item -> item.getId().equals(domainLocation.id()))) {
                throw new IllegalArgumentException("Cannot remove " + domainLocation + " because it doesn't exist");
            }
            if (this.vehicles.isEmpty()) {
                this.publishSolution();
            } else if (this.visits.isEmpty()) {
                this.solverManager.stopSolver();
                this.publishSolution();
            } else {
                this.solverManager.removeLocation(new PlanningLocation(domainLocation));
            }
        }
    }

    @Override
    public void addVehicle(Vehicle domainVehicle) {
        PlanningVehicle vehicle = PlanningVehicleFactory.fromDomain(domainVehicle);
        vehicle.setDepot(this.depot);
        this.vehicles.add(vehicle);
        if (this.visits.isEmpty()) {
            this.publishSolution();
        } else if (this.vehicles.size() == 1) {
            this.solverManager.startSolver(SolutionFactory.solutionFromLocations(this.vehicles, this.depot, this.visits));
        } else {
            this.solverManager.addVehicle(vehicle);
        }
    }

    @Override
    public void removeVehicle(Vehicle domainVehicle) {
        if (!this.vehicles.removeIf(vehicle -> vehicle.getId().equals(domainVehicle.id()))) {
            throw new IllegalArgumentException("Cannot remove " + domainVehicle + " because it doesn't exist");
        }
        if (this.visits.isEmpty()) {
            this.publishSolution();
        } else if (this.vehicles.isEmpty()) {
            this.solverManager.stopSolver();
            this.publishSolution();
        } else {
            this.solverManager.removeVehicle(PlanningVehicleFactory.fromDomain(domainVehicle));
        }
    }

    @Override
    public void changeCapacity(Vehicle domainVehicle) {
        PlanningVehicle vehicle = this.vehicles.stream().filter(item -> item.getId().equals(domainVehicle.id())).findFirst().orElseThrow(() -> new IllegalArgumentException("Cannot change capacity of " + domainVehicle + " because it doesn't exist"));
        vehicle.setCapacity(domainVehicle.capacity());
        if (!this.visits.isEmpty()) {
            this.solverManager.changeCapacity(vehicle);
        } else {
            this.publishSolution();
        }
    }

    @Override
    public void removeAllLocations() {
        this.solverManager.stopSolver();
        this.depot = null;
        this.visits.clear();
        this.publishSolution();
    }

    @Override
    public void removeAllVehicles() {
        this.solverManager.stopSolver();
        this.vehicles.clear();
        this.publishSolution();
    }

    private void publishSolution() {
        this.solutionPublisher.publishSolution(SolutionFactory.solutionFromLocations(this.vehicles, this.depot, this.visits));
    }
}

