/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.vehiclerouting.plugin.planner;

import java.util.Arrays;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.optaplanner.core.api.solver.Solver;
import org.optaplanner.core.api.solver.event.BestSolutionChangedEvent;
import org.optaplanner.core.api.solver.event.SolverEventListener;
import org.optaplanner.core.impl.solver.ProblemFactChange;
import org.optaweb.vehiclerouting.plugin.planner.SolutionPublisher;
import org.optaweb.vehiclerouting.plugin.planner.change.AddVehicle;
import org.optaweb.vehiclerouting.plugin.planner.change.AddVisit;
import org.optaweb.vehiclerouting.plugin.planner.change.ChangeVehicleCapacity;
import org.optaweb.vehiclerouting.plugin.planner.change.RemoveLocation;
import org.optaweb.vehiclerouting.plugin.planner.change.RemoveVehicle;
import org.optaweb.vehiclerouting.plugin.planner.change.RemoveVisit;
import org.optaweb.vehiclerouting.plugin.planner.domain.PlanningLocation;
import org.optaweb.vehiclerouting.plugin.planner.domain.PlanningVehicle;
import org.optaweb.vehiclerouting.plugin.planner.domain.PlanningVisitFactory;
import org.optaweb.vehiclerouting.plugin.planner.domain.VehicleRoutingSolution;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.task.AsyncTaskExecutor;
import org.springframework.stereotype.Component;

@Component(value="optaweb-solver-manager")
class SolverManager
implements SolverEventListener<VehicleRoutingSolution> {
    private static final Logger logger = LoggerFactory.getLogger(SolverManager.class);
    private final Solver<VehicleRoutingSolution> solver;
    private final AsyncTaskExecutor executor;
    private final SolutionPublisher solutionPublisher;
    private Future<VehicleRoutingSolution> solverFuture;

    @Autowired
    SolverManager(Solver<VehicleRoutingSolution> solver, AsyncTaskExecutor executor, SolutionPublisher solutionPublisher) {
        this.solver = solver;
        this.executor = executor;
        this.solutionPublisher = solutionPublisher;
        this.solver.addEventListener((SolverEventListener)this);
    }

    public void bestSolutionChanged(BestSolutionChangedEvent<VehicleRoutingSolution> bestSolutionChangedEvent) {
        if (!bestSolutionChangedEvent.isEveryProblemFactChangeProcessed()) {
            logger.info("Ignoring a new best solution that has some problem facts missing");
            return;
        }
        this.solutionPublisher.publishSolution((VehicleRoutingSolution)bestSolutionChangedEvent.getNewBestSolution());
    }

    void startSolver(VehicleRoutingSolution solution) {
        if (this.solverFuture != null) {
            throw new IllegalStateException("Solver start has already been requested");
        }
        this.solverFuture = this.executor.submit(() -> (VehicleRoutingSolution)this.solver.solve((Object)solution));
    }

    void stopSolver() {
        if (this.solverFuture != null) {
            this.solver.terminateEarly();
            try {
                this.solverFuture.get();
                this.solverFuture = null;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException("Failed to stop solver", e);
            }
            catch (ExecutionException e) {
                throw new RuntimeException("Failed to stop solver", e.getCause());
            }
        }
    }

    private void assertSolverIsAlive() {
        if (this.solverFuture == null) {
            throw new IllegalStateException("Solver has not started yet");
        }
        if (this.solverFuture.isDone()) {
            try {
                this.solverFuture.get();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException("Solver has died", e);
            }
            catch (ExecutionException e) {
                throw new RuntimeException("Solver has died", e.getCause());
            }
            throw new IllegalStateException("Solver has finished solving even though it operates in daemon mode");
        }
    }

    void addLocation(PlanningLocation location) {
        this.assertSolverIsAlive();
        this.solver.addProblemFactChange((ProblemFactChange)new AddVisit(PlanningVisitFactory.visit(location)));
    }

    void removeLocation(PlanningLocation location) {
        this.assertSolverIsAlive();
        this.solver.addProblemFactChanges(Arrays.asList(new RemoveVisit(PlanningVisitFactory.visit(location)), new RemoveLocation(location)));
    }

    void addVehicle(PlanningVehicle vehicle) {
        this.assertSolverIsAlive();
        this.solver.addProblemFactChange((ProblemFactChange)new AddVehicle(vehicle));
    }

    void removeVehicle(PlanningVehicle vehicle) {
        this.assertSolverIsAlive();
        this.solver.addProblemFactChange((ProblemFactChange)new RemoveVehicle(vehicle));
    }

    void changeCapacity(PlanningVehicle vehicle) {
        this.assertSolverIsAlive();
        this.solver.addProblemFactChange((ProblemFactChange)new ChangeVehicleCapacity(vehicle));
    }

    static interface SolvingTask
    extends Callable<VehicleRoutingSolution> {
    }
}

