/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.vehiclerouting.plugin.planner.domain;

import java.math.BigDecimal;
import java.util.Map;
import org.optaweb.vehiclerouting.domain.Location;
import org.optaweb.vehiclerouting.plugin.planner.domain.persistable.AbstractPersistable;

public class PlanningLocation
extends AbstractPersistable {
    private BigDecimal latitude;
    private BigDecimal longitude;
    private String description;
    private Map<PlanningLocation, Double> travelDistanceMap;

    public PlanningLocation() {
    }

    public PlanningLocation(long id, double latitude, double longitude) {
        super(id);
        this.latitude = BigDecimal.valueOf(latitude);
        this.longitude = BigDecimal.valueOf(longitude);
    }

    public PlanningLocation(long id, BigDecimal latitude, BigDecimal longitude) {
        super(id);
        this.latitude = latitude;
        this.longitude = longitude;
    }

    public PlanningLocation(long id, BigDecimal latitude, BigDecimal longitude, String description) {
        super(id);
        this.latitude = latitude;
        this.longitude = longitude;
        this.description = description;
    }

    public PlanningLocation(Location location) {
        if (location.coordinates() != null) {
            this.latitude = location.coordinates().latitude();
            this.longitude = location.coordinates().longitude();
        }
        this.description = location.description();
        this.id = location.id();
    }

    public BigDecimal getLatitude() {
        return this.latitude;
    }

    public void setLatitude(BigDecimal latitude) {
        this.latitude = latitude;
    }

    public BigDecimal getLongitude() {
        return this.longitude;
    }

    public void setLongitude(BigDecimal longitude) {
        this.longitude = longitude;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Map<PlanningLocation, Double> getTravelDistanceMap() {
        return this.travelDistanceMap;
    }

    public void setTravelDistanceMap(Map<PlanningLocation, Double> travelDistanceMap) {
        this.travelDistanceMap = travelDistanceMap;
    }

    public long getDistanceTo(PlanningLocation location) {
        if (this == location) {
            return 0L;
        }
        double distance = this.travelDistanceMap.get(location);
        return (long)(distance * 1000.0 + 0.5);
    }

    public double getAngle(PlanningLocation location) {
        double latitudeDifference = this.latitude.subtract(this.latitude).longValue();
        double longitudeDifference = this.longitude.subtract(this.longitude).longValue();
        return Math.atan2(latitudeDifference, longitudeDifference);
    }

    public String toString() {
        return "PlanningLocation{latitude=" + this.latitude + ",longitude=" + this.longitude + ",description='" + this.description + '\'' + ",travelDistanceMap=" + this.travelDistanceMap + ",id=" + this.id + '}';
    }
}

