/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.vehiclerouting.plugin.planner.domain;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.optaplanner.core.api.score.buildin.hardsoftlong.HardSoftLongScore;
import org.optaweb.vehiclerouting.plugin.planner.domain.PlanningDepot;
import org.optaweb.vehiclerouting.plugin.planner.domain.PlanningLocation;
import org.optaweb.vehiclerouting.plugin.planner.domain.PlanningVehicle;
import org.optaweb.vehiclerouting.plugin.planner.domain.PlanningVisit;
import org.optaweb.vehiclerouting.plugin.planner.domain.PlanningVisitFactory;
import org.optaweb.vehiclerouting.plugin.planner.domain.VehicleRoutingSolution;

public class SolutionFactory {
    private SolutionFactory() {
        throw new AssertionError((Object)"Utility class");
    }

    public static VehicleRoutingSolution emptySolution() {
        VehicleRoutingSolution solution = new VehicleRoutingSolution();
        solution.setName("Empty Solution");
        solution.setLocationList(new ArrayList<PlanningLocation>());
        solution.setVisitList(new ArrayList<PlanningVisit>());
        solution.setDepotList(new ArrayList<PlanningDepot>());
        solution.setVehicleList(new ArrayList<PlanningVehicle>());
        solution.setScore(HardSoftLongScore.ZERO);
        solution.setDistanceUnitOfMeasurement("sec");
        return solution;
    }

    public static VehicleRoutingSolution solutionFromLocations(List<PlanningVehicle> vehicles, PlanningDepot depot, List<? extends PlanningLocation> visitLocations) {
        return SolutionFactory.solution(vehicles, depot, visitLocations.stream().map(PlanningVisitFactory::visit).collect(Collectors.toList()), visitLocations);
    }

    public static VehicleRoutingSolution solutionFromVisits(List<PlanningVehicle> vehicles, PlanningDepot depot, List<PlanningVisit> visits) {
        return SolutionFactory.solution(vehicles, depot, visits, visits.stream().map(PlanningVisit::getLocation).collect(Collectors.toList()));
    }

    private static VehicleRoutingSolution solution(List<PlanningVehicle> vehicles, PlanningDepot depot, List<PlanningVisit> visits, List<? extends PlanningLocation> visitLocations) {
        VehicleRoutingSolution solution = new VehicleRoutingSolution();
        solution.setVehicleList(new ArrayList<PlanningVehicle>(vehicles));
        solution.setLocationList(new ArrayList<PlanningLocation>(visitLocations));
        solution.setDepotList(new ArrayList<PlanningDepot>(1));
        if (depot != null) {
            solution.getLocationList().add(depot.getLocation());
            solution.getDepotList().add(depot);
            SolutionFactory.moveAllVehiclesToDepot(vehicles, depot);
        }
        solution.setVisitList(new ArrayList<PlanningVisit>(visits));
        solution.setScore(HardSoftLongScore.ZERO);
        solution.setDistanceUnitOfMeasurement("sec");
        return solution;
    }

    private static void moveAllVehiclesToDepot(List<PlanningVehicle> vehicles, PlanningDepot depot) {
        vehicles.forEach(vehicle -> vehicle.setDepot(depot));
    }
}

