/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.vehiclerouting.service.distance;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import org.optaweb.vehiclerouting.domain.Location;
import org.optaweb.vehiclerouting.service.distance.DistanceCalculator;
import org.optaweb.vehiclerouting.service.distance.DistanceRepository;
import org.optaweb.vehiclerouting.service.location.DistanceMatrix;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
class DistanceMatrixImpl
implements DistanceMatrix {
    private final DistanceCalculator distanceCalculator;
    private final DistanceRepository distanceRepository;
    private final Map<Location, Map<Long, Double>> matrix = new HashMap<Location, Map<Long, Double>>();

    @Autowired
    DistanceMatrixImpl(DistanceCalculator distanceCalculator, DistanceRepository distanceRepository) {
        this.distanceCalculator = distanceCalculator;
        this.distanceRepository = distanceRepository;
    }

    @Override
    public void addLocation(Location newLocation) {
        ConcurrentHashMap<Long, Double> distancesToOthers = new ConcurrentHashMap<Long, Double>();
        distancesToOthers.put(newLocation.id(), 0.0);
        ((Stream)this.matrix.entrySet().stream().parallel()).forEach(distanceRow -> {
            Location other = (Location)distanceRow.getKey();
            Map distancesFromOther = (Map)distanceRow.getValue();
            distancesFromOther.put(newLocation.id(), this.calculateOrRestoreDistance(other, newLocation));
            distancesToOthers.put(other.id(), this.calculateOrRestoreDistance(newLocation, other));
        });
        this.matrix.put(newLocation, distancesToOthers);
    }

    private double calculateOrRestoreDistance(Location from, Location to) {
        double distance = this.distanceRepository.getDistance(from, to);
        if (distance < 0.0) {
            distance = this.distanceCalculator.travelTimeMillis(from.coordinates(), to.coordinates());
            this.distanceRepository.saveDistance(from, to, distance);
        }
        return distance;
    }

    @Override
    public Map<Long, Double> getRow(Location location) {
        return this.matrix.get(location);
    }

    @Override
    public void clear() {
        this.matrix.clear();
    }
}

