/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.vehiclerouting.plugin.planner;

import java.util.Collections;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.optaweb.vehiclerouting.plugin.planner.SolverManager;
import org.optaweb.vehiclerouting.plugin.planner.domain.DistanceMap;
import org.optaweb.vehiclerouting.plugin.planner.domain.PlanningDepot;
import org.optaweb.vehiclerouting.plugin.planner.domain.PlanningLocation;
import org.optaweb.vehiclerouting.plugin.planner.domain.PlanningLocationFactory;
import org.optaweb.vehiclerouting.plugin.planner.domain.PlanningVehicle;
import org.optaweb.vehiclerouting.plugin.planner.domain.PlanningVehicleFactory;
import org.optaweb.vehiclerouting.plugin.planner.domain.SolutionFactory;
import org.optaweb.vehiclerouting.plugin.planner.domain.VehicleRoutingSolution;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.context.ActiveProfiles;

@SpringBootTest(properties={"optaplanner.solver-config-xml=org/optaweb/vehiclerouting/solver/vehicleRoutingSolverConfig.xml", "optaplanner.solver.termination.spent-limit=100ms"}, webEnvironment=SpringBootTest.WebEnvironment.NONE)
@ActiveProfiles(value={"test"})
class SolverManagerIntegrationTest {
    @Autowired
    private SolverManager solverManager;

    SolverManagerIntegrationTest() {
    }

    private static DistanceMap mockDistanceMap() {
        return location -> 60L;
    }

    @Test
    void solver_should_be_in_daemon_mode() throws InterruptedException {
        PlanningVehicle vehicle = PlanningVehicleFactory.testVehicle((long)1L);
        PlanningLocation depot = PlanningLocationFactory.testLocation((long)1L, (DistanceMap)SolverManagerIntegrationTest.mockDistanceMap());
        PlanningLocation visit = PlanningLocationFactory.testLocation((long)2L, (DistanceMap)SolverManagerIntegrationTest.mockDistanceMap());
        VehicleRoutingSolution solution = SolutionFactory.solutionFromLocations(Collections.singletonList(vehicle), (PlanningDepot)new PlanningDepot(depot), Collections.singletonList(visit));
        this.solverManager.startSolver(solution);
        Thread.sleep(1000L);
        Assertions.assertThatCode(() -> this.solverManager.changeCapacity(vehicle)).doesNotThrowAnyException();
    }
}

