/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.vehiclerouting.plugin.planner;

import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.AdditionalAnswers;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Captor;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.verification.VerificationMode;
import org.optaplanner.core.api.solver.Solver;
import org.optaplanner.core.api.solver.event.BestSolutionChangedEvent;
import org.optaplanner.core.api.solver.event.SolverEventListener;
import org.optaplanner.core.impl.solver.ProblemFactChange;
import org.optaweb.vehiclerouting.plugin.planner.SolutionPublisher;
import org.optaweb.vehiclerouting.plugin.planner.SolverManager;
import org.optaweb.vehiclerouting.plugin.planner.change.AddVehicle;
import org.optaweb.vehiclerouting.plugin.planner.change.AddVisit;
import org.optaweb.vehiclerouting.plugin.planner.change.ChangeVehicleCapacity;
import org.optaweb.vehiclerouting.plugin.planner.change.RemoveLocation;
import org.optaweb.vehiclerouting.plugin.planner.change.RemoveVehicle;
import org.optaweb.vehiclerouting.plugin.planner.change.RemoveVisit;
import org.optaweb.vehiclerouting.plugin.planner.domain.PlanningLocation;
import org.optaweb.vehiclerouting.plugin.planner.domain.PlanningLocationFactory;
import org.optaweb.vehiclerouting.plugin.planner.domain.PlanningVehicle;
import org.optaweb.vehiclerouting.plugin.planner.domain.VehicleRoutingSolution;
import org.springframework.core.task.AsyncTaskExecutor;

@ExtendWith(value={MockitoExtension.class})
class SolverManagerTest {
    @Captor
    private ArgumentCaptor<List<ProblemFactChange<VehicleRoutingSolution>>> problemFactChangeArgumentCaptor;
    @Captor
    private ArgumentCaptor<VehicleRoutingSolution> solutionArgumentCaptor;
    @Mock
    private BestSolutionChangedEvent<VehicleRoutingSolution> bestSolutionChangedEvent;
    @Mock
    private Future<VehicleRoutingSolution> solverFuture;
    @Mock
    private Solver<VehicleRoutingSolution> solver;
    @Mock
    private AsyncTaskExecutor executor;
    @Mock
    private SolutionPublisher solutionPublisher;
    @InjectMocks
    private SolverManager solverManager;

    SolverManagerTest() {
    }

    private void returnSolverFutureWhenSolverIsStarted() {
        Mockito.when((Object)this.executor.submit((Callable)ArgumentMatchers.any(SolverManager.SolvingTask.class))).thenAnswer(AdditionalAnswers.answer(callable -> {
            callable.call();
            return this.solverFuture;
        }));
    }

    @Test
    void should_listen_for_best_solution_events() {
        ((Solver)Mockito.verify(this.solver)).addEventListener((SolverEventListener)this.solverManager);
    }

    @Test
    void ignore_new_best_solutions_when_unprocessed_fact_changes() {
        Mockito.when((Object)this.bestSolutionChangedEvent.isEveryProblemFactChangeProcessed()).thenReturn((Object)false);
        this.solverManager.bestSolutionChanged(this.bestSolutionChangedEvent);
        ((BestSolutionChangedEvent)Mockito.verify(this.bestSolutionChangedEvent, (VerificationMode)Mockito.never())).getNewBestSolution();
        ((SolutionPublisher)Mockito.verify((Object)this.solutionPublisher, (VerificationMode)Mockito.never())).publishSolution((VehicleRoutingSolution)ArgumentMatchers.any());
    }

    @Test
    void publish_new_best_solution_if_all_fact_changes_processed() {
        VehicleRoutingSolution solution = new VehicleRoutingSolution();
        Mockito.when((Object)this.bestSolutionChangedEvent.isEveryProblemFactChangeProcessed()).thenReturn((Object)true);
        Mockito.when((Object)this.bestSolutionChangedEvent.getNewBestSolution()).thenReturn((Object)solution);
        this.solverManager.bestSolutionChanged(this.bestSolutionChangedEvent);
        ((SolutionPublisher)Mockito.verify((Object)this.solutionPublisher)).publishSolution((VehicleRoutingSolution)this.solutionArgumentCaptor.capture());
        VehicleRoutingSolution event = (VehicleRoutingSolution)this.solutionArgumentCaptor.getValue();
        Assertions.assertThat((Object)event).isSameAs((Object)solution);
    }

    @Test
    void startSolver_should_start_solver() {
        this.returnSolverFutureWhenSolverIsStarted();
        this.solverManager.startSolver((VehicleRoutingSolution)Mockito.mock(VehicleRoutingSolution.class));
        ((Solver)Mockito.verify(this.solver)).solve(ArgumentMatchers.any(VehicleRoutingSolution.class));
        Assertions.assertThatIllegalStateException().isThrownBy(() -> this.solverManager.startSolver((VehicleRoutingSolution)Mockito.mock(VehicleRoutingSolution.class)));
    }

    @Test
    void stopSolver_should_terminate_solver() {
        this.returnSolverFutureWhenSolverIsStarted();
        this.solverManager.startSolver((VehicleRoutingSolution)Mockito.mock(VehicleRoutingSolution.class));
        this.solverManager.stopSolver();
        ((Solver)Mockito.verify(this.solver)).terminateEarly();
        this.solverManager.stopSolver();
        ((Solver)Mockito.verify(this.solver)).terminateEarly();
    }

    @Test
    void reset_interrupted_flag() throws ExecutionException, InterruptedException {
        this.returnSolverFutureWhenSolverIsStarted();
        this.solverManager.startSolver((VehicleRoutingSolution)Mockito.mock(VehicleRoutingSolution.class));
        Mockito.when((Object)this.solverFuture.isDone()).thenReturn((Object)true);
        Mockito.when((Object)this.solverFuture.get()).thenThrow(InterruptedException.class);
        Assertions.assertThatExceptionOfType(RuntimeException.class).isThrownBy(() -> this.solverManager.removeLocation(PlanningLocationFactory.testLocation((long)0L)));
        Assertions.assertThat((boolean)Thread.interrupted()).isTrue();
        Assertions.assertThatExceptionOfType(RuntimeException.class).isThrownBy(() -> this.solverManager.stopSolver());
        Assertions.assertThat((boolean)Thread.interrupted()).isTrue();
    }

    @Test
    void change_operations_should_fail_if_solver_has_not_started_yet() {
        Assertions.assertThatIllegalStateException().isThrownBy(() -> this.solverManager.addVehicle((PlanningVehicle)Mockito.mock(PlanningVehicle.class))).withMessageContaining("started");
        Assertions.assertThatIllegalStateException().isThrownBy(() -> this.solverManager.removeVehicle((PlanningVehicle)Mockito.mock(PlanningVehicle.class))).withMessageContaining("started");
        Assertions.assertThatIllegalStateException().isThrownBy(() -> this.solverManager.changeCapacity((PlanningVehicle)Mockito.mock(PlanningVehicle.class))).withMessageContaining("started");
        Assertions.assertThatIllegalStateException().isThrownBy(() -> this.solverManager.addLocation((PlanningLocation)Mockito.mock(PlanningLocation.class))).withMessageContaining("started");
        Assertions.assertThatIllegalStateException().isThrownBy(() -> this.solverManager.removeLocation((PlanningLocation)Mockito.mock(PlanningLocation.class))).withMessageContaining("started");
    }

    @Test
    void change_operations_should_fail_is_solver_has_died() throws ExecutionException, InterruptedException {
        this.returnSolverFutureWhenSolverIsStarted();
        this.solverManager.startSolver((VehicleRoutingSolution)Mockito.mock(VehicleRoutingSolution.class));
        Mockito.when((Object)this.solverFuture.isDone()).thenReturn((Object)true);
        Mockito.when((Object)this.solverFuture.get()).thenThrow(ExecutionException.class);
        Assertions.assertThatExceptionOfType(RuntimeException.class).isThrownBy(() -> this.solverManager.addVehicle((PlanningVehicle)Mockito.mock(PlanningVehicle.class))).withMessageContaining("died");
        Assertions.assertThatExceptionOfType(RuntimeException.class).isThrownBy(() -> this.solverManager.removeVehicle((PlanningVehicle)Mockito.mock(PlanningVehicle.class))).withMessageContaining("died");
        Assertions.assertThatExceptionOfType(RuntimeException.class).isThrownBy(() -> this.solverManager.changeCapacity((PlanningVehicle)Mockito.mock(PlanningVehicle.class))).withMessageContaining("died");
        Assertions.assertThatExceptionOfType(RuntimeException.class).isThrownBy(() -> this.solverManager.addLocation((PlanningLocation)Mockito.mock(PlanningLocation.class))).withMessageContaining("died");
        Assertions.assertThatExceptionOfType(RuntimeException.class).isThrownBy(() -> this.solverManager.removeLocation((PlanningLocation)Mockito.mock(PlanningLocation.class))).withMessageContaining("died");
    }

    @Test
    void change_operations_should_submit_problem_fact_changes_to_solver() {
        this.returnSolverFutureWhenSolverIsStarted();
        this.solverManager.startSolver((VehicleRoutingSolution)Mockito.mock(VehicleRoutingSolution.class));
        Mockito.when((Object)this.solverFuture.isDone()).thenReturn((Object)false);
        this.solverManager.addVehicle((PlanningVehicle)Mockito.mock(PlanningVehicle.class));
        ((Solver)Mockito.verify(this.solver)).addProblemFactChange((ProblemFactChange)ArgumentMatchers.any(AddVehicle.class));
        this.solverManager.removeVehicle((PlanningVehicle)Mockito.mock(PlanningVehicle.class));
        ((Solver)Mockito.verify(this.solver)).addProblemFactChange((ProblemFactChange)ArgumentMatchers.any(RemoveVehicle.class));
        this.solverManager.changeCapacity((PlanningVehicle)Mockito.mock(PlanningVehicle.class));
        ((Solver)Mockito.verify(this.solver)).addProblemFactChange((ProblemFactChange)ArgumentMatchers.any(ChangeVehicleCapacity.class));
        this.solverManager.addLocation((PlanningLocation)Mockito.mock(PlanningLocation.class));
        ((Solver)Mockito.verify(this.solver)).addProblemFactChange((ProblemFactChange)ArgumentMatchers.any(AddVisit.class));
        this.solverManager.removeLocation((PlanningLocation)Mockito.mock(PlanningLocation.class));
        ((Solver)Mockito.verify(this.solver)).addProblemFactChanges((List)this.problemFactChangeArgumentCaptor.capture());
        List problemFactChanges = (List)this.problemFactChangeArgumentCaptor.getValue();
        Assertions.assertThat((List)problemFactChanges).hasSize(2);
        Assertions.assertThat(problemFactChanges.get(0)).isInstanceOf(RemoveVisit.class);
        Assertions.assertThat(problemFactChanges.get(1)).isInstanceOf(RemoveLocation.class);
    }
}

