/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.vehiclerouting.plugin.planner.change;

import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.optaplanner.core.impl.score.director.ScoreDirector;
import org.optaweb.vehiclerouting.plugin.planner.change.ChangeVehicleCapacity;
import org.optaweb.vehiclerouting.plugin.planner.domain.PlanningDepot;
import org.optaweb.vehiclerouting.plugin.planner.domain.PlanningLocation;
import org.optaweb.vehiclerouting.plugin.planner.domain.PlanningLocationFactory;
import org.optaweb.vehiclerouting.plugin.planner.domain.PlanningVehicle;
import org.optaweb.vehiclerouting.plugin.planner.domain.PlanningVehicleFactory;
import org.optaweb.vehiclerouting.plugin.planner.domain.VehicleRoutingSolution;

@ExtendWith(value={MockitoExtension.class})
class ChangeVehicleCapacityTest {
    @Mock
    private ScoreDirector<VehicleRoutingSolution> scoreDirector;

    ChangeVehicleCapacityTest() {
    }

    @Test
    void change_vehicle_capacity() {
        PlanningLocation location = PlanningLocationFactory.testLocation((long)1L);
        PlanningDepot depot = new PlanningDepot();
        depot.setLocation(location);
        int oldCapacity = 100;
        int newCapacity = 50;
        PlanningVehicle workingVehicle = new PlanningVehicle();
        workingVehicle.setId(1L);
        workingVehicle.setDepot(depot);
        workingVehicle.setCapacity(oldCapacity);
        PlanningVehicle changeVehicle = new PlanningVehicle();
        changeVehicle.setId(1L);
        changeVehicle.setDepot(depot);
        changeVehicle.setCapacity(newCapacity);
        Mockito.when((Object)this.scoreDirector.lookUpWorkingObject((Object)changeVehicle)).thenReturn((Object)workingVehicle);
        ChangeVehicleCapacity changeVehicleCapacity = new ChangeVehicleCapacity(changeVehicle);
        changeVehicleCapacity.doChange(this.scoreDirector);
        Assertions.assertThat((int)workingVehicle.getCapacity()).isEqualTo(newCapacity);
        ((ScoreDirector)Mockito.verify(this.scoreDirector)).beforeProblemPropertyChanged((Object)workingVehicle);
        ((ScoreDirector)Mockito.verify(this.scoreDirector)).afterProblemPropertyChanged((Object)workingVehicle);
        ((ScoreDirector)Mockito.verify(this.scoreDirector)).triggerVariableListeners();
    }

    @Test
    void fail_fast_if_working_object_is_null() {
        ChangeVehicleCapacity changeVehicleCapacity = new ChangeVehicleCapacity(PlanningVehicleFactory.testVehicle((long)1L));
        Assertions.assertThatIllegalStateException().isThrownBy(() -> changeVehicleCapacity.doChange(this.scoreDirector)).withMessageContaining("working copy of");
    }
}

