/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.vehiclerouting.plugin.planner.change;

import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.optaplanner.core.impl.score.director.ScoreDirector;
import org.optaweb.vehiclerouting.plugin.planner.change.RemoveVehicle;
import org.optaweb.vehiclerouting.plugin.planner.domain.PlanningDepot;
import org.optaweb.vehiclerouting.plugin.planner.domain.PlanningLocation;
import org.optaweb.vehiclerouting.plugin.planner.domain.PlanningLocationFactory;
import org.optaweb.vehiclerouting.plugin.planner.domain.PlanningVehicle;
import org.optaweb.vehiclerouting.plugin.planner.domain.PlanningVehicleFactory;
import org.optaweb.vehiclerouting.plugin.planner.domain.PlanningVisit;
import org.optaweb.vehiclerouting.plugin.planner.domain.PlanningVisitFactory;
import org.optaweb.vehiclerouting.plugin.planner.domain.SolutionFactory;
import org.optaweb.vehiclerouting.plugin.planner.domain.Standstill;
import org.optaweb.vehiclerouting.plugin.planner.domain.VehicleRoutingSolution;

@ExtendWith(value={MockitoExtension.class})
class RemoveVehicleTest {
    @Mock
    private ScoreDirector<VehicleRoutingSolution> scoreDirector;

    RemoveVehicleTest() {
    }

    @Test
    void remove_vehicle() {
        VehicleRoutingSolution solution = SolutionFactory.emptySolution();
        Mockito.when((Object)this.scoreDirector.getWorkingSolution()).thenReturn((Object)solution);
        PlanningLocation location = PlanningLocationFactory.testLocation((long)1L);
        PlanningDepot depot = new PlanningDepot();
        depot.setLocation(location);
        PlanningVehicle removedVehicle = new PlanningVehicle();
        removedVehicle.setId(1L);
        removedVehicle.setDepot(depot);
        PlanningVehicle otherVehicle = new PlanningVehicle();
        otherVehicle.setId(2L);
        otherVehicle.setDepot(depot);
        solution.getVehicleList().add(removedVehicle);
        solution.getVehicleList().add(otherVehicle);
        Mockito.when((Object)this.scoreDirector.lookUpWorkingObject((Object)removedVehicle)).thenReturn((Object)removedVehicle);
        PlanningVisit firstVisit = RemoveVehicleTest.visit(1L);
        PlanningVisit lastVisit = RemoveVehicleTest.visit(2L);
        solution.getVisitList().add(firstVisit);
        solution.getVisitList().add(lastVisit);
        removedVehicle.setNextVisit(firstVisit);
        firstVisit.setPreviousStandstill((Standstill)removedVehicle);
        firstVisit.setVehicle(removedVehicle);
        firstVisit.setNextVisit(lastVisit);
        lastVisit.setPreviousStandstill((Standstill)firstVisit);
        lastVisit.setVehicle(removedVehicle);
        RemoveVehicle removeVehicle = new RemoveVehicle(removedVehicle);
        removeVehicle.doChange(this.scoreDirector);
        Assertions.assertThat((Object)firstVisit.getPreviousStandstill()).isNull();
        Assertions.assertThat((Object)lastVisit.getPreviousStandstill()).isNull();
        Assertions.assertThat((List)solution.getVehicleList()).containsExactly((Object[])new PlanningVehicle[]{otherVehicle});
        ((ScoreDirector)Mockito.verify(this.scoreDirector)).beforeVariableChanged((Object)firstVisit, "previousStandstill");
        ((ScoreDirector)Mockito.verify(this.scoreDirector)).afterVariableChanged((Object)firstVisit, "previousStandstill");
        ((ScoreDirector)Mockito.verify(this.scoreDirector)).beforeVariableChanged((Object)lastVisit, "previousStandstill");
        ((ScoreDirector)Mockito.verify(this.scoreDirector)).afterVariableChanged((Object)lastVisit, "previousStandstill");
        ((ScoreDirector)Mockito.verify(this.scoreDirector)).beforeProblemFactRemoved(ArgumentMatchers.any(PlanningVehicle.class));
        ((ScoreDirector)Mockito.verify(this.scoreDirector)).afterProblemFactRemoved(ArgumentMatchers.any(PlanningVehicle.class));
        ((ScoreDirector)Mockito.verify(this.scoreDirector)).triggerVariableListeners();
    }

    @Test
    void fail_fast_if_working_solution_vehicle_list_does_not_contain_working_vehicle() {
        VehicleRoutingSolution solution = SolutionFactory.emptySolution();
        PlanningLocation location = PlanningLocationFactory.testLocation((long)1L);
        PlanningDepot depot = new PlanningDepot();
        depot.setLocation(location);
        long removedId = 111L;
        PlanningVehicle removedVehicle = new PlanningVehicle();
        removedVehicle.setId(removedId);
        removedVehicle.setDepot(depot);
        long wrongId = 222L;
        PlanningVehicle wrongVehicle = new PlanningVehicle();
        wrongVehicle.setId(wrongId);
        wrongVehicle.setDepot(depot);
        solution.getVehicleList().add(wrongVehicle);
        Mockito.when((Object)this.scoreDirector.getWorkingSolution()).thenReturn((Object)solution);
        Mockito.when((Object)this.scoreDirector.lookUpWorkingObject((Object)removedVehicle)).thenReturn((Object)removedVehicle);
        RemoveVehicle removeVehicle = new RemoveVehicle(removedVehicle);
        Assertions.assertThatIllegalStateException().isThrownBy(() -> removeVehicle.doChange(this.scoreDirector)).withMessageMatching(".*List .*" + wrongId + ".* doesn't contain the working.*" + removedId + ".*");
    }

    @Test
    void fail_fast_if_working_object_is_null() {
        Mockito.when((Object)this.scoreDirector.getWorkingSolution()).thenReturn((Object)SolutionFactory.emptySolution());
        Assertions.assertThatIllegalStateException().isThrownBy(() -> new RemoveVehicle(PlanningVehicleFactory.testVehicle((long)1L)).doChange(this.scoreDirector)).withMessageContaining("working copy of");
    }

    private static PlanningVisit visit(long id) {
        return PlanningVisitFactory.fromLocation((PlanningLocation)PlanningLocationFactory.testLocation((long)id));
    }
}

